/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.ImmutableSortedSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DirectMappedDexApplication;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.PresortedComparable;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.shaking.ProguardMemberRule;
import com.android.tools.r8.utils.CollectionUtils;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class AppInfoWithLiveness
extends AppInfoWithSubtyping {
    public final SortedSet<DexType> liveTypes;
    final SortedSet<DexType> instantiatedAnnotationTypes;
    public final SortedSet<DexType> instantiatedAppServices;
    final SortedSet<DexType> instantiatedTypes;
    private final IdentityHashMap<DexType, Boolean> indirectlyInstantiatedTypes = new IdentityHashMap();
    final SortedSet<DexMethod> targetedMethods;
    public final SortedSet<DexMethod> bootstrapMethods;
    public final SortedSet<DexMethod> methodsTargetedByInvokeDynamic;
    final SortedSet<DexMethod> virtualMethodsTargetedByInvokeDirect;
    public final SortedSet<DexMethod> liveMethods;
    private final SortedSet<DexField> fieldsRead;
    private SortedSet<DexField> fieldsWritten;
    private SortedSet<DexField> staticFieldsWrittenOnlyInEnclosingStaticInitializer;
    public final SortedMap<DexField, Set<DexEncodedMethod>> instanceFieldReads;
    public final SortedMap<DexField, Set<DexEncodedMethod>> instanceFieldWrites;
    public final SortedMap<DexField, Set<DexEncodedMethod>> staticFieldReads;
    public final SortedMap<DexField, Set<DexEncodedMethod>> staticFieldWrites;
    public final SortedMap<DexMethod, Set<DexEncodedMethod>> virtualInvokes;
    public final SortedMap<DexMethod, Set<DexEncodedMethod>> interfaceInvokes;
    public final SortedMap<DexMethod, Set<DexEncodedMethod>> superInvokes;
    public final SortedMap<DexMethod, Set<DexEncodedMethod>> directInvokes;
    public final SortedMap<DexMethod, Set<DexEncodedMethod>> staticInvokes;
    public final Set<DexCallSite> callSites;
    public final SortedSet<DexMethod> brokenSuperInvokes;
    final Set<DexReference> pinnedItems;
    public final Map<DexReference, ProguardMemberRule> mayHaveSideEffects;
    public final Map<DexReference, ProguardMemberRule> noSideEffects;
    public final Map<DexReference, ProguardMemberRule> assumedValues;
    public final Set<DexMethod> alwaysInline;
    public final Set<DexMethod> forceInline;
    public final Set<DexMethod> neverInline;
    public final Set<DexMethod> keepConstantArguments;
    public final Set<DexMethod> keepUnusedArguments;
    public final Set<DexType> neverClassInline;
    public final Set<DexType> neverMerge;
    private final Set<DexReference> neverPropagateValue;
    public final Object2BooleanMap<DexReference> identifierNameStrings;
    final Set<DexType> prunedTypes;
    final Map<DexField, Int2ReferenceMap<DexField>> switchMaps;
    final Map<DexType, Reference2IntMap<DexField>> ordinalsMaps;
    final ImmutableSortedSet<DexType> instantiatedLambdas;

    private AppInfoWithLiveness(DexApplication application, SortedSet<DexType> liveTypes, SortedSet<DexType> instantiatedAnnotationTypes, SortedSet<DexType> instantiatedAppServices, SortedSet<DexType> instantiatedTypes, SortedSet<DexMethod> targetedMethods, SortedSet<DexMethod> bootstrapMethods, SortedSet<DexMethod> methodsTargetedByInvokeDynamic, SortedSet<DexMethod> virtualMethodsTargetedByInvokeDirect, SortedSet<DexMethod> liveMethods, SortedSet<DexField> fieldsRead, SortedSet<DexField> fieldsWritten, SortedSet<DexField> staticFieldsWrittenOnlyInEnclosingStaticInitializer, SortedMap<DexField, Set<DexEncodedMethod>> instanceFieldReads, SortedMap<DexField, Set<DexEncodedMethod>> instanceFieldWrites, SortedMap<DexField, Set<DexEncodedMethod>> staticFieldReads, SortedMap<DexField, Set<DexEncodedMethod>> staticFieldWrites, SortedMap<DexMethod, Set<DexEncodedMethod>> virtualInvokes, SortedMap<DexMethod, Set<DexEncodedMethod>> interfaceInvokes, SortedMap<DexMethod, Set<DexEncodedMethod>> superInvokes, SortedMap<DexMethod, Set<DexEncodedMethod>> directInvokes, SortedMap<DexMethod, Set<DexEncodedMethod>> staticInvokes, Set<DexCallSite> callSites, SortedSet<DexMethod> brokenSuperInvokes, Set<DexReference> pinnedItems, Map<DexReference, ProguardMemberRule> mayHaveSideEffects, Map<DexReference, ProguardMemberRule> noSideEffects, Map<DexReference, ProguardMemberRule> assumedValues, Set<DexMethod> alwaysInline, Set<DexMethod> forceInline, Set<DexMethod> neverInline, Set<DexMethod> keepConstantArguments, Set<DexMethod> keepUnusedArguments, Set<DexType> neverClassInline, Set<DexType> neverMerge, Set<DexReference> neverPropagateValue, Object2BooleanMap<DexReference> identifierNameStrings, Set<DexType> prunedTypes, Map<DexField, Int2ReferenceMap<DexField>> switchMaps, Map<DexType, Reference2IntMap<DexField>> ordinalsMaps, ImmutableSortedSet<DexType> instantiatedLambdas) {
        super(application);
        this.liveTypes = liveTypes;
        this.instantiatedAnnotationTypes = instantiatedAnnotationTypes;
        this.instantiatedAppServices = instantiatedAppServices;
        this.instantiatedTypes = instantiatedTypes;
        this.targetedMethods = targetedMethods;
        this.bootstrapMethods = bootstrapMethods;
        this.methodsTargetedByInvokeDynamic = methodsTargetedByInvokeDynamic;
        this.virtualMethodsTargetedByInvokeDirect = virtualMethodsTargetedByInvokeDirect;
        this.liveMethods = liveMethods;
        this.instanceFieldReads = instanceFieldReads;
        this.instanceFieldWrites = instanceFieldWrites;
        this.staticFieldReads = staticFieldReads;
        this.staticFieldWrites = staticFieldWrites;
        this.fieldsRead = fieldsRead;
        this.fieldsWritten = fieldsWritten;
        this.staticFieldsWrittenOnlyInEnclosingStaticInitializer = staticFieldsWrittenOnlyInEnclosingStaticInitializer;
        this.pinnedItems = pinnedItems;
        this.mayHaveSideEffects = mayHaveSideEffects;
        this.noSideEffects = noSideEffects;
        this.assumedValues = assumedValues;
        this.virtualInvokes = virtualInvokes;
        this.interfaceInvokes = interfaceInvokes;
        this.superInvokes = superInvokes;
        this.directInvokes = directInvokes;
        this.staticInvokes = staticInvokes;
        this.callSites = callSites;
        this.brokenSuperInvokes = brokenSuperInvokes;
        this.alwaysInline = alwaysInline;
        this.forceInline = forceInline;
        this.neverInline = neverInline;
        this.keepConstantArguments = keepConstantArguments;
        this.keepUnusedArguments = keepUnusedArguments;
        this.neverClassInline = neverClassInline;
        this.neverMerge = neverMerge;
        this.neverPropagateValue = neverPropagateValue;
        this.identifierNameStrings = identifierNameStrings;
        this.prunedTypes = prunedTypes;
        this.switchMaps = switchMaps;
        this.ordinalsMaps = ordinalsMaps;
        this.instantiatedLambdas = instantiatedLambdas;
        assert (Sets.intersection(instanceFieldReads.keySet(), staticFieldReads.keySet()).isEmpty());
        assert (Sets.intersection(instanceFieldWrites.keySet(), staticFieldWrites.keySet()).isEmpty());
    }

    public AppInfoWithLiveness(AppInfoWithSubtyping appInfoWithSubtyping, SortedSet<DexType> liveTypes, SortedSet<DexType> instantiatedAnnotationTypes, SortedSet<DexType> instantiatedAppServices, SortedSet<DexType> instantiatedTypes, SortedSet<DexMethod> targetedMethods, SortedSet<DexMethod> bootstrapMethods, SortedSet<DexMethod> methodsTargetedByInvokeDynamic, SortedSet<DexMethod> virtualMethodsTargetedByInvokeDirect, SortedSet<DexMethod> liveMethods, SortedSet<DexField> fieldsRead, SortedSet<DexField> fieldsWritten, SortedSet<DexField> staticFieldsWrittenOnlyInEnclosingStaticInitializer, SortedMap<DexField, Set<DexEncodedMethod>> instanceFieldReads, SortedMap<DexField, Set<DexEncodedMethod>> instanceFieldWrites, SortedMap<DexField, Set<DexEncodedMethod>> staticFieldReads, SortedMap<DexField, Set<DexEncodedMethod>> staticFieldWrites, SortedMap<DexMethod, Set<DexEncodedMethod>> virtualInvokes, SortedMap<DexMethod, Set<DexEncodedMethod>> interfaceInvokes, SortedMap<DexMethod, Set<DexEncodedMethod>> superInvokes, SortedMap<DexMethod, Set<DexEncodedMethod>> directInvokes, SortedMap<DexMethod, Set<DexEncodedMethod>> staticInvokes, Set<DexCallSite> callSites, SortedSet<DexMethod> brokenSuperInvokes, Set<DexReference> pinnedItems, Map<DexReference, ProguardMemberRule> mayHaveSideEffects, Map<DexReference, ProguardMemberRule> noSideEffects, Map<DexReference, ProguardMemberRule> assumedValues, Set<DexMethod> alwaysInline, Set<DexMethod> forceInline, Set<DexMethod> neverInline, Set<DexMethod> keepConstantArguments, Set<DexMethod> keepUnusedArguments, Set<DexType> neverClassInline, Set<DexType> neverMerge, Set<DexReference> neverPropagateValue, Object2BooleanMap<DexReference> identifierNameStrings, Set<DexType> prunedTypes, Map<DexField, Int2ReferenceMap<DexField>> switchMaps, Map<DexType, Reference2IntMap<DexField>> ordinalsMaps, ImmutableSortedSet<DexType> instantiatedLambdas) {
        super(appInfoWithSubtyping);
        this.liveTypes = liveTypes;
        this.instantiatedAnnotationTypes = instantiatedAnnotationTypes;
        this.instantiatedAppServices = instantiatedAppServices;
        this.instantiatedTypes = instantiatedTypes;
        this.targetedMethods = targetedMethods;
        this.bootstrapMethods = bootstrapMethods;
        this.methodsTargetedByInvokeDynamic = methodsTargetedByInvokeDynamic;
        this.virtualMethodsTargetedByInvokeDirect = virtualMethodsTargetedByInvokeDirect;
        this.liveMethods = liveMethods;
        this.instanceFieldReads = instanceFieldReads;
        this.instanceFieldWrites = instanceFieldWrites;
        this.staticFieldReads = staticFieldReads;
        this.staticFieldWrites = staticFieldWrites;
        this.fieldsRead = fieldsRead;
        this.fieldsWritten = fieldsWritten;
        this.staticFieldsWrittenOnlyInEnclosingStaticInitializer = staticFieldsWrittenOnlyInEnclosingStaticInitializer;
        this.pinnedItems = pinnedItems;
        this.mayHaveSideEffects = mayHaveSideEffects;
        this.noSideEffects = noSideEffects;
        this.assumedValues = assumedValues;
        this.virtualInvokes = virtualInvokes;
        this.interfaceInvokes = interfaceInvokes;
        this.superInvokes = superInvokes;
        this.directInvokes = directInvokes;
        this.staticInvokes = staticInvokes;
        this.callSites = callSites;
        this.brokenSuperInvokes = brokenSuperInvokes;
        this.alwaysInline = alwaysInline;
        this.forceInline = forceInline;
        this.neverInline = neverInline;
        this.keepConstantArguments = keepConstantArguments;
        this.keepUnusedArguments = keepUnusedArguments;
        this.neverClassInline = neverClassInline;
        this.neverMerge = neverMerge;
        this.neverPropagateValue = neverPropagateValue;
        this.identifierNameStrings = identifierNameStrings;
        this.prunedTypes = prunedTypes;
        this.switchMaps = switchMaps;
        this.ordinalsMaps = ordinalsMaps;
        this.instantiatedLambdas = instantiatedLambdas;
        assert (Sets.intersection(instanceFieldReads.keySet(), staticFieldReads.keySet()).isEmpty());
        assert (Sets.intersection(instanceFieldWrites.keySet(), staticFieldWrites.keySet()).isEmpty());
    }

    private AppInfoWithLiveness(AppInfoWithLiveness previous) {
        this(previous, previous.app(), null);
    }

    private AppInfoWithLiveness(AppInfoWithLiveness previous, DexApplication application, Collection<DexType> removedClasses) {
        this(application, previous.liveTypes, previous.instantiatedAnnotationTypes, previous.instantiatedAppServices, previous.instantiatedTypes, previous.targetedMethods, previous.bootstrapMethods, previous.methodsTargetedByInvokeDynamic, previous.virtualMethodsTargetedByInvokeDirect, previous.liveMethods, previous.fieldsRead, previous.fieldsWritten, previous.staticFieldsWrittenOnlyInEnclosingStaticInitializer, previous.instanceFieldReads, previous.instanceFieldWrites, previous.staticFieldReads, previous.staticFieldWrites, previous.virtualInvokes, previous.interfaceInvokes, previous.superInvokes, previous.directInvokes, previous.staticInvokes, previous.callSites, previous.brokenSuperInvokes, previous.pinnedItems, previous.mayHaveSideEffects, previous.noSideEffects, previous.assumedValues, previous.alwaysInline, previous.forceInline, previous.neverInline, previous.keepConstantArguments, previous.keepUnusedArguments, previous.neverClassInline, previous.neverMerge, previous.neverPropagateValue, previous.identifierNameStrings, removedClasses == null ? previous.prunedTypes : CollectionUtils.mergeSets(previous.prunedTypes, removedClasses), previous.switchMaps, previous.ordinalsMaps, previous.instantiatedLambdas);
        this.copyMetadataFromPrevious(previous);
        assert (removedClasses == null || this.assertNoItemRemoved(previous.pinnedItems, removedClasses));
        assert (Sets.intersection(this.instanceFieldReads.keySet(), this.staticFieldReads.keySet()).isEmpty());
        assert (Sets.intersection(this.instanceFieldWrites.keySet(), this.staticFieldWrites.keySet()).isEmpty());
    }

    private AppInfoWithLiveness(AppInfoWithLiveness previous, DirectMappedDexApplication application, GraphLense lense) {
        super(application);
        this.liveTypes = AppInfoWithLiveness.rewriteItems(previous.liveTypes, lense::lookupType);
        this.instantiatedAnnotationTypes = AppInfoWithLiveness.rewriteItems(previous.instantiatedAnnotationTypes, lense::lookupType);
        this.instantiatedAppServices = AppInfoWithLiveness.rewriteItems(previous.instantiatedAppServices, lense::lookupType);
        this.instantiatedTypes = AppInfoWithLiveness.rewriteItems(previous.instantiatedTypes, lense::lookupType);
        this.instantiatedLambdas = AppInfoWithLiveness.rewriteItems(previous.instantiatedLambdas, lense::lookupType);
        this.targetedMethods = lense.rewriteMethodsConservatively(previous.targetedMethods);
        this.bootstrapMethods = lense.rewriteMethodsConservatively(previous.bootstrapMethods);
        this.methodsTargetedByInvokeDynamic = lense.rewriteMethodsConservatively(previous.methodsTargetedByInvokeDynamic);
        this.virtualMethodsTargetedByInvokeDirect = lense.rewriteMethodsConservatively(previous.virtualMethodsTargetedByInvokeDirect);
        this.liveMethods = lense.rewriteMethodsConservatively(previous.liveMethods);
        this.instanceFieldReads = AppInfoWithLiveness.rewriteKeysWhileMergingValues(previous.instanceFieldReads, lense::lookupField);
        this.instanceFieldWrites = AppInfoWithLiveness.rewriteKeysWhileMergingValues(previous.instanceFieldWrites, lense::lookupField);
        this.staticFieldReads = AppInfoWithLiveness.rewriteKeysWhileMergingValues(previous.staticFieldReads, lense::lookupField);
        this.staticFieldWrites = AppInfoWithLiveness.rewriteKeysWhileMergingValues(previous.staticFieldWrites, lense::lookupField);
        this.fieldsRead = AppInfoWithLiveness.rewriteItems(previous.fieldsRead, lense::lookupField);
        this.fieldsWritten = AppInfoWithLiveness.rewriteItems(previous.fieldsWritten, lense::lookupField);
        this.staticFieldsWrittenOnlyInEnclosingStaticInitializer = AppInfoWithLiveness.rewriteItems(previous.staticFieldsWrittenOnlyInEnclosingStaticInitializer, lense::lookupField);
        this.pinnedItems = lense.rewriteReferencesConservatively(previous.pinnedItems);
        this.virtualInvokes = AppInfoWithLiveness.rewriteKeysConservativelyWhileMergingValues(previous.virtualInvokes, lense::lookupMethodInAllContexts);
        this.interfaceInvokes = AppInfoWithLiveness.rewriteKeysConservativelyWhileMergingValues(previous.interfaceInvokes, lense::lookupMethodInAllContexts);
        this.superInvokes = AppInfoWithLiveness.rewriteKeysConservativelyWhileMergingValues(previous.superInvokes, lense::lookupMethodInAllContexts);
        this.directInvokes = AppInfoWithLiveness.rewriteKeysConservativelyWhileMergingValues(previous.directInvokes, lense::lookupMethodInAllContexts);
        this.staticInvokes = AppInfoWithLiveness.rewriteKeysConservativelyWhileMergingValues(previous.staticInvokes, lense::lookupMethodInAllContexts);
        this.callSites = previous.callSites;
        this.brokenSuperInvokes = lense.rewriteMethodsConservatively(previous.brokenSuperInvokes);
        this.prunedTypes = previous.prunedTypes;
        this.mayHaveSideEffects = GraphLense.rewriteReferenceKeys(previous.mayHaveSideEffects, lense::lookupReference);
        this.noSideEffects = GraphLense.rewriteReferenceKeys(previous.noSideEffects, lense::lookupReference);
        this.assumedValues = GraphLense.rewriteReferenceKeys(previous.assumedValues, lense::lookupReference);
        assert (lense.assertDefinitionsNotModified(previous.alwaysInline.stream().map(this::definitionFor).filter(Objects::nonNull).collect(Collectors.toList())));
        this.alwaysInline = lense.rewriteMethodsWithRenamedSignature(previous.alwaysInline);
        this.forceInline = lense.rewriteMethodsWithRenamedSignature(previous.forceInline);
        this.neverInline = lense.rewriteMethodsWithRenamedSignature(previous.neverInline);
        this.keepConstantArguments = lense.rewriteMethodsWithRenamedSignature(previous.keepConstantArguments);
        this.keepUnusedArguments = lense.rewriteMethodsWithRenamedSignature(previous.keepUnusedArguments);
        assert (lense.assertDefinitionsNotModified(previous.neverMerge.stream().map(this::definitionFor).filter(Objects::nonNull).collect(Collectors.toList())));
        this.neverClassInline = AppInfoWithLiveness.rewriteItems(previous.neverClassInline, lense::lookupType);
        this.neverMerge = AppInfoWithLiveness.rewriteItems(previous.neverMerge, lense::lookupType);
        this.neverPropagateValue = lense.rewriteReferencesConservatively(previous.neverPropagateValue);
        this.identifierNameStrings = lense.rewriteReferencesConservatively(previous.identifierNameStrings);
        assert (lense.assertDefinitionsNotModified(previous.switchMaps.keySet().stream().map(this::definitionFor).filter(Objects::nonNull).collect(Collectors.toList())));
        this.switchMaps = GraphLense.rewriteReferenceKeys(previous.switchMaps, lense::lookupField);
        this.ordinalsMaps = GraphLense.rewriteReferenceKeys(previous.ordinalsMaps, lense::lookupType);
        assert (Sets.intersection(this.instanceFieldReads.keySet(), this.staticFieldReads.keySet()).isEmpty());
        assert (Sets.intersection(this.instanceFieldWrites.keySet(), this.staticFieldWrites.keySet()).isEmpty());
    }

    public AppInfoWithLiveness(AppInfoWithLiveness previous, Map<DexField, Int2ReferenceMap<DexField>> switchMaps, Map<DexType, Reference2IntMap<DexField>> ordinalsMaps) {
        super(previous);
        this.liveTypes = previous.liveTypes;
        this.instantiatedAnnotationTypes = previous.instantiatedAnnotationTypes;
        this.instantiatedAppServices = previous.instantiatedAppServices;
        this.instantiatedTypes = previous.instantiatedTypes;
        this.instantiatedLambdas = previous.instantiatedLambdas;
        this.targetedMethods = previous.targetedMethods;
        this.bootstrapMethods = previous.bootstrapMethods;
        this.methodsTargetedByInvokeDynamic = previous.methodsTargetedByInvokeDynamic;
        this.virtualMethodsTargetedByInvokeDirect = previous.virtualMethodsTargetedByInvokeDirect;
        this.liveMethods = previous.liveMethods;
        this.instanceFieldReads = previous.instanceFieldReads;
        this.instanceFieldWrites = previous.instanceFieldWrites;
        this.staticFieldReads = previous.staticFieldReads;
        this.staticFieldWrites = previous.staticFieldWrites;
        this.fieldsRead = previous.fieldsRead;
        this.fieldsWritten = previous.fieldsWritten;
        this.staticFieldsWrittenOnlyInEnclosingStaticInitializer = previous.staticFieldsWrittenOnlyInEnclosingStaticInitializer;
        this.pinnedItems = previous.pinnedItems;
        this.mayHaveSideEffects = previous.mayHaveSideEffects;
        this.noSideEffects = previous.noSideEffects;
        this.assumedValues = previous.assumedValues;
        this.virtualInvokes = previous.virtualInvokes;
        this.interfaceInvokes = previous.interfaceInvokes;
        this.superInvokes = previous.superInvokes;
        this.directInvokes = previous.directInvokes;
        this.staticInvokes = previous.staticInvokes;
        this.callSites = previous.callSites;
        this.brokenSuperInvokes = previous.brokenSuperInvokes;
        this.alwaysInline = previous.alwaysInline;
        this.forceInline = previous.forceInline;
        this.neverInline = previous.neverInline;
        this.keepConstantArguments = previous.keepConstantArguments;
        this.keepUnusedArguments = previous.keepUnusedArguments;
        this.neverClassInline = previous.neverClassInline;
        this.neverMerge = previous.neverMerge;
        this.neverPropagateValue = previous.neverPropagateValue;
        this.identifierNameStrings = previous.identifierNameStrings;
        this.prunedTypes = previous.prunedTypes;
        this.switchMaps = switchMaps;
        this.ordinalsMaps = ordinalsMaps;
        previous.markObsolete();
    }

    public Collection<DexClass> computeReachableInterfaces(Set<DexCallSite> desugaredCallSites) {
        Set<DexClass> interfaces = Sets.newIdentityHashSet();
        Set<DexType> seen = Sets.newIdentityHashSet();
        ArrayDeque<DexType> worklist = new ArrayDeque<DexType>();
        for (DexProgramClass clazz : this.classes()) {
            worklist.add(clazz.type);
        }
        for (DexCallSite callSite : desugaredCallSites) {
            for (DexEncodedMethod method : this.lookupLambdaImplementedMethods(callSite)) {
                worklist.add(method.method.holder);
            }
        }
        for (DexCallSite callSite : this.callSites) {
            for (DexEncodedMethod method : this.lookupLambdaImplementedMethods(callSite)) {
                worklist.add(method.method.holder);
            }
        }
        while (!worklist.isEmpty()) {
            DexClass definition;
            DexType type = (DexType)worklist.pop();
            if (!seen.add(type) || (definition = this.definitionFor(type)) == null) continue;
            if (definition.isInterface()) {
                interfaces.add(definition);
            }
            if (definition.superType != null) {
                worklist.add(definition.superType);
            }
            Collections.addAll(worklist, definition.interfaces.values);
        }
        return interfaces;
    }

    public AppInfoWithLiveness withoutStaticFieldsWrites(Set<DexField> noLongerWrittenFields) {
        assert (this.checkIfObsolete());
        if (noLongerWrittenFields.isEmpty()) {
            return this;
        }
        AppInfoWithLiveness result = new AppInfoWithLiveness(this);
        Predicate<DexField> isFieldWritten = field -> !noLongerWrittenFields.contains(field);
        result.fieldsWritten = this.filter(this.fieldsWritten, isFieldWritten);
        result.staticFieldsWrittenOnlyInEnclosingStaticInitializer = this.filter(this.staticFieldsWrittenOnlyInEnclosingStaticInitializer, isFieldWritten);
        return result;
    }

    private <T extends PresortedComparable<T>> SortedSet<T> filter(Set<T> items, Predicate<T> predicate) {
        return ImmutableSortedSet.copyOf(PresortedComparable::slowCompareTo, items.stream().filter(predicate).collect(Collectors.toList()));
    }

    public Reference2IntMap<DexField> getOrdinalsMapFor(DexType enumClass) {
        assert (this.checkIfObsolete());
        return this.ordinalsMaps.get(enumClass);
    }

    public Int2ReferenceMap<DexField> getSwitchMapFor(DexField field) {
        assert (this.checkIfObsolete());
        return this.switchMaps.get(field);
    }

    private boolean assertNoItemRemoved(Collection<DexReference> items, Collection<DexType> types) {
        ImmutableSet<DexType> typeSet = ImmutableSet.copyOf(types);
        for (DexReference item : items) {
            DexType typeToCheck;
            if (item.isDexType()) {
                typeToCheck = item.asDexType();
            } else if (item.isDexMethod()) {
                typeToCheck = item.asDexMethod().holder;
            } else {
                assert (item.isDexField());
                typeToCheck = item.asDexField().holder;
            }
            assert (!typeSet.contains(typeToCheck));
        }
        return true;
    }

    public boolean isInstantiatedDirectly(DexType type) {
        assert (this.checkIfObsolete());
        assert (type.isClassType());
        return type.isD8R8SynthesizedClassType() || this.instantiatedTypes.contains(type) || this.instantiatedLambdas.contains(type) || this.instantiatedAnnotationTypes.contains(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInstantiatedIndirectly(DexType type) {
        assert (this.checkIfObsolete());
        assert (type.isClassType());
        IdentityHashMap<DexType, Boolean> identityHashMap = this.indirectlyInstantiatedTypes;
        synchronized (identityHashMap) {
            if (this.indirectlyInstantiatedTypes.containsKey(type)) {
                return this.indirectlyInstantiatedTypes.get(type);
            }
            for (DexType directSubtype : this.allImmediateSubtypes(type)) {
                if (!this.isInstantiatedDirectlyOrIndirectly(directSubtype)) continue;
                this.indirectlyInstantiatedTypes.put(type, Boolean.TRUE);
                return true;
            }
            this.indirectlyInstantiatedTypes.put(type, Boolean.FALSE);
            return false;
        }
    }

    public boolean isInstantiatedDirectlyOrIndirectly(DexType type) {
        assert (this.checkIfObsolete());
        assert (type.isClassType());
        return this.isInstantiatedDirectly(type) || this.isInstantiatedIndirectly(type);
    }

    public boolean isFieldRead(DexField field) {
        assert (this.checkIfObsolete());
        return this.fieldsRead.contains(field) || this.isPinned(field) || field.holder.isD8R8SynthesizedClassType() || this.isLibraryOrClasspathField(field);
    }

    public boolean isFieldWritten(DexField field) {
        assert (this.checkIfObsolete());
        return this.fieldsWritten.contains(field) || this.isPinned(field) || field.holder.isD8R8SynthesizedClassType() || this.isLibraryOrClasspathField(field);
    }

    public boolean isStaticFieldWrittenOnlyInEnclosingStaticInitializer(DexField field) {
        assert (this.checkIfObsolete());
        assert (this.isFieldWritten(field));
        return this.staticFieldsWrittenOnlyInEnclosingStaticInitializer.contains(field);
    }

    public boolean mayPropagateValueFor(DexReference reference) {
        assert (this.checkIfObsolete());
        return !this.isPinned(reference) && !this.neverPropagateValue.contains(reference);
    }

    private boolean isLibraryOrClasspathField(DexField field) {
        DexClass holder = this.definitionFor(field.holder);
        return holder == null || holder.isLibraryClass() || holder.isClasspathClass();
    }

    private static <T extends PresortedComparable<T>> ImmutableSortedSet<T> rewriteItems(Set<T> original, Function<T, T> rewrite) {
        ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(PresortedComparable::slowCompare);
        for (PresortedComparable item : original) {
            builder.add((PresortedComparable)rewrite.apply(item));
        }
        return builder.build();
    }

    private static <T extends PresortedComparable<T>, S> SortedMap<T, Set<S>> rewriteKeysWhileMergingValues(Map<T, Set<S>> original, Function<T, T> rewrite) {
        TreeMap<PresortedComparable, Set> result = new TreeMap<PresortedComparable, Set>(PresortedComparable::slowCompare);
        for (PresortedComparable item : original.keySet()) {
            PresortedComparable rewrittenKey = (PresortedComparable)rewrite.apply(item);
            result.computeIfAbsent(rewrittenKey, k -> Sets.newIdentityHashSet()).addAll((Collection)original.get(item));
        }
        return Collections.unmodifiableSortedMap(result);
    }

    private static <T extends PresortedComparable<T>, S> SortedMap<T, Set<S>> rewriteKeysConservativelyWhileMergingValues(Map<T, Set<S>> original, Function<T, Set<T>> rewrite) {
        TreeMap<PresortedComparable, Set> result = new TreeMap<PresortedComparable, Set>(PresortedComparable::slowCompare);
        for (PresortedComparable item : original.keySet()) {
            Set<T> rewrittenKeys = rewrite.apply(item);
            for (PresortedComparable rewrittenKey : rewrittenKeys) {
                result.computeIfAbsent(rewrittenKey, k -> Sets.newIdentityHashSet()).addAll((Collection)original.get(item));
            }
        }
        return Collections.unmodifiableSortedMap(result);
    }

    @Override
    protected boolean hasAnyInstantiatedLambdas(DexType type) {
        assert (this.checkIfObsolete());
        return this.instantiatedLambdas.contains(type);
    }

    @Override
    public boolean hasLiveness() {
        assert (this.checkIfObsolete());
        return true;
    }

    @Override
    public AppInfoWithLiveness withLiveness() {
        assert (this.checkIfObsolete());
        return this;
    }

    public boolean isPinned(DexReference reference) {
        assert (this.checkIfObsolete());
        return this.pinnedItems.contains(reference);
    }

    public Iterable<DexReference> getPinnedItems() {
        assert (this.checkIfObsolete());
        return this.pinnedItems;
    }

    public AppInfoWithLiveness prunedCopyFrom(DexApplication application, Collection<DexType> removedClasses) {
        assert (this.checkIfObsolete());
        return new AppInfoWithLiveness(this, application, removedClasses);
    }

    public AppInfoWithLiveness rewrittenWithLense(DirectMappedDexApplication application, GraphLense lense) {
        assert (this.checkIfObsolete());
        return new AppInfoWithLiveness(this, application, lense);
    }

    public boolean wasPruned(DexType type) {
        assert (this.checkIfObsolete());
        return this.prunedTypes.contains(type);
    }

    public Set<DexType> getPrunedTypes() {
        assert (this.checkIfObsolete());
        return this.prunedTypes;
    }

    public DexEncodedMethod lookupSingleTarget(Invoke.Type type, DexMethod target, DexType invocationContext) {
        assert (this.checkIfObsolete());
        DexType holder = target.holder;
        if (!holder.isClassType()) {
            return null;
        }
        switch (type) {
            case VIRTUAL: {
                return this.lookupSingleVirtualTarget(target);
            }
            case INTERFACE: {
                return this.lookupSingleInterfaceTarget(target);
            }
            case DIRECT: {
                return this.lookupDirectTarget(target);
            }
            case STATIC: {
                return this.lookupStaticTarget(target);
            }
            case SUPER: {
                return this.lookupSuperTarget(target, invocationContext);
            }
        }
        return null;
    }

    public DexEncodedMethod lookupSingleVirtualTarget(DexMethod method) {
        assert (this.checkIfObsolete());
        return this.lookupSingleVirtualTarget(method, method.holder);
    }

    public DexEncodedMethod lookupSingleVirtualTarget(DexMethod method, DexType refinedReceiverType) {
        DexClass refinedHolder;
        assert (this.checkIfObsolete());
        assert (method != null);
        assert (this.isSubtype(refinedReceiverType, method.holder));
        if (method.holder.isArrayType()) {
            return null;
        }
        DexClass holder = this.definitionFor(method.holder);
        if (holder == null || holder.isNotProgramClass() || holder.isInterface()) {
            return null;
        }
        boolean refinedReceiverIsStrictSubType = refinedReceiverType != method.holder;
        DexClass dexClass = refinedHolder = refinedReceiverIsStrictSubType ? this.definitionFor(refinedReceiverType) : holder;
        assert (refinedHolder != null);
        assert (refinedHolder.isProgramClass());
        if (method.isSingleVirtualMethodCached(refinedReceiverType)) {
            return method.getSingleVirtualMethodCache(refinedReceiverType);
        }
        if (this.pinnedItems.contains(method.holder)) {
            method.setSingleVirtualMethodCache(refinedReceiverType, null);
            return null;
        }
        AppInfo.ResolutionResult topMethod = this.resolveMethod(method.holder, method);
        if (!topMethod.hasSingleTarget() || !topMethod.asSingleTarget().isVirtualMethod()) {
            method.setSingleVirtualMethodCache(refinedReceiverType, null);
            return null;
        }
        if (refinedReceiverIsStrictSubType) {
            topMethod = this.resolveMethod(refinedReceiverType, method);
        }
        DexEncodedMethod topSingleTarget = topMethod.asSingleTarget();
        DexClass topHolder = this.definitionFor(topSingleTarget.method.holder);
        boolean topIsFromInterface = topHolder.isInterface();
        DexEncodedMethod result = this.findSingleTargetFromSubtypes(refinedReceiverType, method, topSingleTarget, !refinedHolder.accessFlags.isAbstract(), topIsFromInterface);
        result = result == DexEncodedMethod.SENTINEL ? null : result;
        method.setSingleVirtualMethodCache(refinedReceiverType, result);
        return result;
    }

    private DexEncodedMethod findSingleTargetFromSubtypes(DexType type, DexMethod method, DexEncodedMethod candidate, boolean candidateIsReachable, boolean checkForInterfaceConflicts) {
        DexEncodedMethod result;
        DexEncodedMethod dexEncodedMethod = result = candidateIsReachable ? candidate : null;
        if (this.pinnedItems.contains(type)) {
            return DexEncodedMethod.SENTINEL;
        }
        for (DexType subtype : this.allExtendsSubtypes(type)) {
            boolean newCandidateIsReachable;
            DexClass clazz = this.definitionFor(subtype);
            DexEncodedMethod target = clazz.lookupVirtualMethod(method);
            if (target != null && !target.isPrivateMethod() && !clazz.accessFlags.isAbstract()) {
                if (result != null && result != target) {
                    return DexEncodedMethod.SENTINEL;
                }
                result = target;
            }
            if (checkForInterfaceConflicts && this.interfacesMayHaveDefaultFor(clazz.interfaces, method)) {
                return DexEncodedMethod.SENTINEL;
            }
            DexEncodedMethod newCandidate = target == null ? candidate : target;
            DexEncodedMethod subtypeTarget = this.findSingleTargetFromSubtypes(subtype, method, newCandidate, newCandidateIsReachable = !clazz.accessFlags.isAbstract() || target == null && candidateIsReachable, checkForInterfaceConflicts);
            if (subtypeTarget == null) continue;
            if (result != null && result != subtypeTarget) {
                return DexEncodedMethod.SENTINEL;
            }
            result = subtypeTarget;
        }
        return result;
    }

    private boolean interfacesMayHaveDefaultFor(DexTypeList ifaces, DexMethod method) {
        for (DexType iface : ifaces.values) {
            DexClass clazz = this.definitionFor(iface);
            if (clazz == null || clazz.isNotProgramClass()) {
                return true;
            }
            DexEncodedMethod candidate = clazz.lookupMethod(method);
            if (candidate != null && !candidate.accessFlags.isAbstract()) {
                return true;
            }
            if (!this.interfacesMayHaveDefaultFor(clazz.interfaces, method)) continue;
            return true;
        }
        return false;
    }

    public DexEncodedMethod lookupSingleInterfaceTarget(DexMethod method) {
        assert (this.checkIfObsolete());
        return this.lookupSingleInterfaceTarget(method, method.holder);
    }

    public DexEncodedMethod lookupSingleInterfaceTarget(DexMethod method, DexType refinedReceiverType) {
        assert (this.checkIfObsolete());
        if (this.instantiatedLambdas.contains(method.holder)) {
            return null;
        }
        DexClass holder = this.definitionFor(method.holder);
        if (holder == null || holder.isNotProgramClass() || !holder.accessFlags.isInterface()) {
            return null;
        }
        AppInfo.ResolutionResult topTarget = this.resolveMethodOnInterface(method.holder, method);
        if (topTarget.asResultOfResolve() == null) {
            return null;
        }
        if (this.pinnedItems.contains(method.holder)) {
            return null;
        }
        DexEncodedMethod result = null;
        Set<DexType> subTypesToExplore = refinedReceiverType == method.holder ? this.subtypes(method.holder) : Iterables.concat(ImmutableList.of(refinedReceiverType), this.subtypes(refinedReceiverType));
        for (DexType type : subTypesToExplore) {
            if (this.instantiatedLambdas.contains(type)) {
                return null;
            }
            if (this.pinnedItems.contains(type)) {
                return null;
            }
            DexClass clazz = this.definitionFor(type);
            if (clazz.isInterface() || clazz.accessFlags.isAbstract()) continue;
            AppInfo.ResolutionResult resolutionResult = this.resolveMethodOnClass(type, method);
            if (resolutionResult.hasSingleTarget()) {
                if (result != null && result != resolutionResult.asSingleTarget()) {
                    return null;
                }
                result = resolutionResult.asSingleTarget();
                continue;
            }
            return null;
        }
        return result == null || !result.isVirtualMethod() ? null : result;
    }

    public AppInfoWithLiveness addSwitchMaps(Map<DexField, Int2ReferenceMap<DexField>> switchMaps) {
        assert (this.checkIfObsolete());
        assert (this.switchMaps.isEmpty());
        return new AppInfoWithLiveness(this, switchMaps, this.ordinalsMaps);
    }

    public AppInfoWithLiveness addEnumOrdinalMaps(Map<DexType, Reference2IntMap<DexField>> ordinalsMaps) {
        assert (this.checkIfObsolete());
        assert (this.ordinalsMaps.isEmpty());
        return new AppInfoWithLiveness(this, this.switchMaps, ordinalsMaps);
    }
}

