/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.shaking.RootSetBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DiscardedChecker {
    private final Set<DexReference> checkDiscarded;
    private final Iterable<DexProgramClass> classes;

    public DiscardedChecker(RootSetBuilder.RootSet rootSet, Iterable<DexProgramClass> classes) {
        this.checkDiscarded = new HashSet<DexReference>(rootSet.checkDiscarded);
        this.classes = classes;
    }

    public List<DexDefinition> run() {
        ArrayList<DexDefinition> failed = new ArrayList<DexDefinition>(this.checkDiscarded.size());
        for (DexProgramClass clazz : this.classes) {
            this.checkItem(clazz, failed);
            clazz.forEachMethod(method -> this.checkItem((DexDefinition)method, (List<DexDefinition>)failed));
            clazz.forEachField(field -> this.checkItem((DexDefinition)field, (List<DexDefinition>)failed));
        }
        return failed;
    }

    private void checkItem(DexDefinition item, List<DexDefinition> failed) {
        DexReference reference = item.toReference();
        if (this.checkDiscarded.contains(reference)) {
            failed.add(item);
        }
    }
}

