/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.ImmutableSortedSet;
import com.android.tools.r8.com.google.common.collect.Maps;
import com.android.tools.r8.com.google.common.collect.Queues;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.experimental.graphinfo.AnnotationGraphNode;
import com.android.tools.r8.experimental.graphinfo.ClassGraphNode;
import com.android.tools.r8.experimental.graphinfo.FieldGraphNode;
import com.android.tools.r8.experimental.graphinfo.GraphConsumer;
import com.android.tools.r8.experimental.graphinfo.GraphEdgeInfo;
import com.android.tools.r8.experimental.graphinfo.GraphNode;
import com.android.tools.r8.experimental.graphinfo.KeepRuleGraphNode;
import com.android.tools.r8.experimental.graphinfo.MethodGraphNode;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CachedHashValueDexItem;
import com.android.tools.r8.graph.Descriptor;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.KeyedDexItem;
import com.android.tools.r8.graph.PresortedComparable;
import com.android.tools.r8.graph.TopDownClassHierarchyTraversal;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.code.ArrayPut;
import com.android.tools.r8.ir.code.ConstantValueUtils;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.desugar.LambdaDescriptor;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import com.android.tools.r8.naming.IdentifierNameStringUtils;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.references.Reference;
import com.android.tools.r8.references.TypeReference;
import com.android.tools.r8.shaking.AnnotationRemover;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.EnqueuerUtils;
import com.android.tools.r8.shaking.KeepReason;
import com.android.tools.r8.shaking.ProguardClassFilter;
import com.android.tools.r8.shaking.ProguardConfiguration;
import com.android.tools.r8.shaking.ProguardConfigurationUtils;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.shaking.ScopedDexMethodSet;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class Enqueuer {
    private final boolean forceProguardCompatibility;
    private boolean tracingMainDex = false;
    private final AppInfoWithSubtyping appInfo;
    private final AppView<? extends AppInfoWithSubtyping> appView;
    private final InternalOptions options;
    private RootSetBuilder.RootSet rootSet;
    private ProguardClassFilter dontWarnPatterns;
    private final Map<DexType, Set<TargetWithContext<DexMethod>>> virtualInvokes = Maps.newIdentityHashMap();
    private final Map<DexType, Set<TargetWithContext<DexMethod>>> interfaceInvokes = Maps.newIdentityHashMap();
    private final Map<DexType, Set<TargetWithContext<DexMethod>>> superInvokes = Maps.newIdentityHashMap();
    private final Map<DexType, Set<TargetWithContext<DexMethod>>> directInvokes = Maps.newIdentityHashMap();
    private final Map<DexType, Set<TargetWithContext<DexMethod>>> staticInvokes = Maps.newIdentityHashMap();
    private final Map<DexType, Set<TargetWithContext<DexField>>> instanceFieldsWritten = Maps.newIdentityHashMap();
    private final Map<DexType, Set<TargetWithContext<DexField>>> instanceFieldsRead = Maps.newIdentityHashMap();
    private final Map<DexType, Set<TargetWithContext<DexField>>> staticFieldsRead = Maps.newIdentityHashMap();
    private final Map<DexType, Set<TargetWithContext<DexField>>> staticFieldsWritten = Maps.newIdentityHashMap();
    private final Set<DexField> staticFieldsWrittenOutsideEnclosingStaticInitializer = Sets.newIdentityHashSet();
    private final Set<DexCallSite> callSites = Sets.newIdentityHashSet();
    private final Set<DexReference> identifierNameStrings = Sets.newIdentityHashSet();
    private final Map<DexItem, AnnotationGraphNode> annotationNodes = new IdentityHashMap<DexItem, AnnotationGraphNode>();
    private final Map<DexType, ClassGraphNode> classNodes = new IdentityHashMap<DexType, ClassGraphNode>();
    private final Map<DexMethod, MethodGraphNode> methodNodes = new IdentityHashMap<DexMethod, MethodGraphNode>();
    private final Map<DexField, FieldGraphNode> fieldNodes = new IdentityHashMap<DexField, FieldGraphNode>();
    private final Map<ProguardKeepRule, KeepRuleGraphNode> ruleNodes = new IdentityHashMap<ProguardKeepRule, KeepRuleGraphNode>();
    private final Map<GraphEdgeInfo.EdgeKind, GraphEdgeInfo> reasonInfo = new IdentityHashMap<GraphEdgeInfo.EdgeKind, GraphEdgeInfo>();
    private final Set<DexMethod> brokenSuperInvokes = Sets.newIdentityHashSet();
    private final Map<DexType, SetWithReason<DexEncodedMethod>> reachableVirtualMethods = Maps.newIdentityHashMap();
    private final Map<DexEncodedMethod, Set<DexEncodedMethod>> superInvokeDependencies = Maps.newIdentityHashMap();
    private final Map<DexType, SetWithReason<DexEncodedField>> reachableInstanceFields = Maps.newIdentityHashMap();
    private final Set<DexType> liveTypes = Sets.newIdentityHashSet();
    private final SetWithReason<DexAnnotation> liveAnnotations = new SetWithReason<DexAnnotation>(this::registerAnnotation);
    private final SetWithReason<DexType> instantiatedTypes = new SetWithReason<DexType>(this::registerType);
    private final SetWithReason<DexEncodedMethod> targetedMethods = new SetWithReason<DexEncodedMethod>(this::registerMethod);
    private final Set<DexMethod> bootstrapMethods = Sets.newIdentityHashSet();
    private final Set<DexMethod> methodsTargetedByInvokeDynamic = Sets.newIdentityHashSet();
    private final Set<DexMethod> lambdaMethodsTargetedByInvokeDynamic = Sets.newIdentityHashSet();
    private final Set<DexMethod> virtualMethodsTargetedByInvokeDirect = Sets.newIdentityHashSet();
    private final SetWithReason<DexEncodedMethod> liveMethods = new SetWithReason<DexEncodedMethod>(this::registerMethod);
    private final SetWithReason<DexEncodedField> liveFields = new SetWithReason<DexEncodedField>(this::registerField);
    private final Set<DexType> instantiatedAppServices = Sets.newIdentityHashSet();
    private final SetWithReason<DexType> instantiatedLambdas = new SetWithReason<DexType>(this::registerType);
    private final Queue<Action> workList = Queues.newArrayDeque();
    private final Queue<Action> proguardCompatibilityWorkList = Queues.newArrayDeque();
    private final Set<DexEncodedMethod> pendingReflectiveUses = Sets.newLinkedHashSet();
    private final Set<DexMethod> virtualTargetsMarkedAsReachable = Sets.newIdentityHashSet();
    private final Set<DexReference> reportedMissing = Sets.newIdentityHashSet();
    private final Set<DexReference> pinnedItems = Sets.newIdentityHashSet();
    private final Map<DexType, Set<DexAnnotation>> deferredAnnotations = new IdentityHashMap<DexType, Set<DexAnnotation>>();
    private final ProguardConfiguration.Builder compatibility;
    private final GraphConsumer keptGraphConsumer;

    public Enqueuer(AppView<? extends AppInfoWithSubtyping> appView, InternalOptions options, GraphConsumer keptGraphConsumer) {
        this(appView, options, keptGraphConsumer, null);
    }

    public Enqueuer(AppView<? extends AppInfoWithSubtyping> appView, InternalOptions options, GraphConsumer keptGraphConsumer, ProguardConfiguration.Builder compatibility) {
        assert (appView.appServices() != null);
        this.appInfo = appView.appInfo();
        this.appView = appView;
        this.compatibility = compatibility;
        this.forceProguardCompatibility = options.forceProguardCompatibility;
        this.keptGraphConsumer = keptGraphConsumer;
        this.options = options;
    }

    private Set<DexField> staticFieldsWrittenOnlyInEnclosingStaticInitializer() {
        Set<DexField> result = Sets.newIdentityHashSet();
        Set<DexField> visited = Sets.newIdentityHashSet();
        for (Set<TargetWithContext<DexField>> targetsWithContext : this.staticFieldsWritten.values()) {
            for (TargetWithContext<DexField> targetWithContext : targetsWithContext) {
                DexEncodedField encodedStaticFieldWritten;
                DexField staticFieldWritten = (DexField)((TargetWithContext)targetWithContext).target;
                if (!visited.add(staticFieldWritten) || (encodedStaticFieldWritten = this.appInfo.resolveField(staticFieldWritten)) == null || !encodedStaticFieldWritten.isProgramField(this.appInfo)) continue;
                result.add(encodedStaticFieldWritten.field);
            }
        }
        result.removeAll(this.staticFieldsWrittenOutsideEnclosingStaticInitializer);
        result.removeAll(this.pinnedItems.stream().filter(DexReference::isDexField).map(DexReference::asDexField).collect(Collectors.toSet()));
        return result;
    }

    private static <T> SetWithReason<T> newSetWithoutReasonReporter() {
        return new SetWithReason<Object>((f, r) -> {});
    }

    private void enqueueRootItems(Map<DexReference, Set<ProguardKeepRule>> items) {
        items.entrySet().forEach(this::enqueueRootItem);
    }

    private void enqueueRootItem(Map.Entry<DexReference, Set<ProguardKeepRule>> root) {
        DexDefinition item = this.appView.definitionFor(root.getKey());
        if (item != null) {
            this.enqueueRootItem(item, root.getValue());
        }
    }

    private void enqueueRootItem(DexDefinition item, Set<ProguardKeepRule> rules) {
        assert (!rules.isEmpty());
        if (this.keptGraphConsumer != null) {
            GraphNode node = this.getGraphNode(item.toReference());
            for (ProguardKeepRule rule : rules) {
                this.registerEdge(node, KeepReason.dueToKeepRule(rule));
            }
        }
        this.internalEnqueueRootItem(item, KeepReason.dueToKeepRule(rules.iterator().next()));
    }

    private void enqueueRootItem(DexDefinition item, KeepReason reason) {
        if (this.keptGraphConsumer != null) {
            this.registerEdge(this.getGraphNode(item.toReference()), reason);
        }
        this.internalEnqueueRootItem(item, reason);
    }

    private void internalEnqueueRootItem(DexDefinition item, KeepReason reason) {
        if (item.isDexClass()) {
            DexClass clazz = item.asDexClass();
            this.workList.add(Action.markInstantiated(clazz, reason));
            if (clazz.hasDefaultInitializer()) {
                if (this.forceProguardCompatibility) {
                    ProguardKeepRule compatRule = ProguardConfigurationUtils.buildDefaultInitializerKeepRule(clazz);
                    this.proguardCompatibilityWorkList.add(Action.markMethodLive(clazz.getDefaultInitializer(), KeepReason.dueToProguardCompatibilityKeepRule(compatRule)));
                }
                if (clazz.isExternalizable(this.appView)) {
                    this.workList.add(Action.markMethodLive(clazz.getDefaultInitializer(), reason));
                }
            }
        } else if (item.isDexEncodedField()) {
            this.workList.add(Action.markFieldKept(item.asDexEncodedField(), reason));
        } else if (item.isDexEncodedMethod()) {
            this.workList.add(Action.markMethodKept(item.asDexEncodedMethod(), reason));
        } else {
            throw new IllegalArgumentException(item.toString());
        }
        this.pinnedItems.add(item.toReference());
    }

    private void enqueueFirstNonSerializableClassInitializer(DexClass clazz, KeepReason reason) {
        assert (clazz.isProgramClass() && clazz.isSerializable(this.appView));
        while (clazz != null && clazz.isProgramClass() && clazz.isSerializable(this.appView)) {
            clazz = this.appView.definitionFor(clazz.superType);
        }
        if (clazz != null && clazz.isProgramClass() && clazz.hasDefaultInitializer()) {
            this.workList.add(Action.markMethodLive(clazz.getDefaultInitializer(), reason));
        }
    }

    private void enqueueHolderIfDependentNonStaticMember(DexClass holder, Map<DexReference, Set<ProguardKeepRule>> dependentItems) {
        for (Map.Entry<DexReference, Set<ProguardKeepRule>> entry : dependentItems.entrySet()) {
            DexReference dependentItem = entry.getKey();
            if (dependentItem.isDexType()) continue;
            DexDefinition dependentDefinition = this.appView.definitionFor(dependentItem);
            if (dependentDefinition == null) {
                assert (false);
                continue;
            }
            if (dependentDefinition.isStaticMember()) continue;
            this.enqueueRootItem((DexDefinition)holder, entry.getValue());
            break;
        }
    }

    private <S extends DexItem, T extends Descriptor<S, T>> boolean registerItemWithTarget(Map<DexType, Set<T>> seen, T item) {
        assert (item.isDexField() || item.isDexMethod());
        DexType itemHolder = item.isDexField() ? item.asDexField().holder : item.asDexMethod().holder;
        DexType holder = itemHolder.toBaseType(this.appView.dexItemFactory());
        if (!holder.isClassType()) {
            return false;
        }
        this.markTypeAsLive(holder);
        return seen.computeIfAbsent(itemHolder, ignore -> Sets.newIdentityHashSet()).add(item);
    }

    private <S extends DexItem, T extends Descriptor<S, T>> boolean registerItemWithTargetAndContext(Map<DexType, Set<TargetWithContext<T>>> seen, T item, DexEncodedMethod context) {
        assert (item.isDexField() || item.isDexMethod());
        DexType itemHolder = item.isDexField() ? item.asDexField().holder : item.asDexMethod().holder;
        DexType holder = itemHolder.toBaseType(this.appView.dexItemFactory());
        if (!holder.isClassType()) {
            return false;
        }
        this.markTypeAsLive(holder);
        return seen.computeIfAbsent(itemHolder, ignore -> new HashSet()).add(new TargetWithContext(item, context, null));
    }

    private DexMethod getInvokeSuperTarget(DexMethod method, DexEncodedMethod currentMethod) {
        DexClass methodHolderClass = this.appView.definitionFor(method.holder);
        if (methodHolderClass != null && methodHolderClass.isInterface()) {
            return method;
        }
        DexClass holderClass = this.appView.definitionFor(currentMethod.method.holder);
        if (holderClass == null || holderClass.superType == null || holderClass.isInterface()) {
            return method;
        }
        return this.appView.dexItemFactory().createMethod(holderClass.superType, method.proto, method.name);
    }

    private void markTypeAsLive(DexType type) {
        if (!(type = type.toBaseType(this.appView.dexItemFactory())).isClassType()) {
            return;
        }
        if (this.liveTypes.add(type)) {
            DexEncodedMethod clinit;
            DexClass holder = this.appView.definitionFor(type);
            if (holder == null) {
                this.reportMissingClass(type);
                return;
            }
            for (DexType iface : holder.interfaces.values) {
                this.markTypeAsLive(iface);
            }
            if (holder.superType != null) {
                this.markTypeAsLive(holder.superType);
                if (holder.isNotProgramClass()) {
                    this.ensureNotFromProgramOrThrow(holder.superType, type);
                    for (DexType iface : holder.interfaces.values) {
                        this.ensureNotFromProgramOrThrow(iface, type);
                    }
                }
            }
            KeepReason reason = KeepReason.reachableFromLiveType(type);
            if (holder.isProgramClass() && holder.hasNonTrivialClassInitializer() && (clinit = holder.getClassInitializer()) != null) {
                assert (clinit.method.holder == holder.type);
                this.markDirectStaticOrConstructorMethodAsLive(clinit, reason);
            }
            if (holder.isProgramClass() && holder.isSerializable(this.appView)) {
                this.enqueueFirstNonSerializableClassInitializer(holder, reason);
            }
            if (holder.isProgramClass()) {
                Set<DexAnnotation> annotations;
                if (!holder.annotations.isEmpty()) {
                    this.processAnnotations(holder, holder.annotations.annotations);
                }
                if ((annotations = this.deferredAnnotations.remove(type)) != null && !annotations.isEmpty()) {
                    assert (holder.accessFlags.isAnnotation());
                    assert (annotations.stream().allMatch(a -> a.annotation.type == holder.type));
                    annotations.forEach(annotation -> this.handleAnnotation(holder, (DexAnnotation)annotation));
                }
            } else assert (!this.deferredAnnotations.containsKey(holder.type));
            Map<DexReference, Set<ProguardKeepRule>> dependentItems = this.rootSet.getDependentItems(holder);
            this.enqueueHolderIfDependentNonStaticMember(holder, dependentItems);
            this.enqueueRootItems(dependentItems);
        }
    }

    private void processAnnotations(DexDefinition holder, DexAnnotation[] annotations) {
        for (DexAnnotation annotation : annotations) {
            this.processAnnotation(holder, annotation);
        }
    }

    private void processAnnotation(DexDefinition holder, DexAnnotation annotation) {
        this.handleAnnotation(holder, annotation);
    }

    private void handleAnnotation(DexDefinition holder, DexAnnotation annotation) {
        boolean isLive;
        assert (!holder.isDexClass() || holder.asDexClass().isProgramClass());
        DexType type = annotation.annotation.type;
        boolean annotationTypeIsLibraryClass = this.appView.definitionFor(type) == null || this.appView.definitionFor(type).isNotProgramClass();
        boolean bl = isLive = annotationTypeIsLibraryClass || this.liveTypes.contains(type);
        if (!AnnotationRemover.shouldKeepAnnotation(annotation, isLive, this.appView.dexItemFactory(), this.options)) {
            if (!annotationTypeIsLibraryClass) {
                this.deferredAnnotations.computeIfAbsent(type, ignore -> new HashSet()).add(annotation);
            }
            return;
        }
        this.liveAnnotations.add(annotation, KeepReason.annotatedOn(holder));
        AnnotationReferenceMarker referenceMarker = new AnnotationReferenceMarker(annotation.annotation.type, this.appView.dexItemFactory());
        annotation.annotation.collectIndexedItems(referenceMarker);
    }

    private void handleInvokeOfStaticTarget(DexMethod method, KeepReason reason) {
        AppInfo.ResolutionResult resolutionResult = this.appInfo.resolveMethod(method.holder, method);
        if (resolutionResult == null) {
            this.reportMissingMethod(method);
            return;
        }
        resolutionResult.forEachTarget(m -> this.markMethodAsTargeted((DexEncodedMethod)m, reason));
        DexEncodedMethod targetMethod = this.appInfo.dispatchStaticInvoke(resolutionResult);
        if (targetMethod != null) {
            this.markDirectStaticOrConstructorMethodAsLive(targetMethod, reason);
        }
    }

    private void handleInvokeOfDirectTarget(DexMethod method, KeepReason reason) {
        AppInfo.ResolutionResult resolutionResult = this.appInfo.resolveMethod(method.holder, method);
        if (resolutionResult == null) {
            this.reportMissingMethod(method);
            return;
        }
        resolutionResult.forEachTarget(m -> this.markMethodAsTargeted((DexEncodedMethod)m, reason));
        DexEncodedMethod target = this.appInfo.dispatchDirectInvoke(resolutionResult);
        if (target != null) {
            this.markDirectStaticOrConstructorMethodAsLive(target, reason);
            if (target.isVirtualMethod()) {
                this.virtualMethodsTargetedByInvokeDirect.add(target.method);
            }
        }
    }

    private void ensureNotFromProgramOrThrow(DexType type, DexType context) {
        if (this.tracingMainDex) {
            return;
        }
        DexClass clazz = this.appView.definitionFor(type);
        if (clazz != null && clazz.isProgramClass() && !this.dontWarnPatterns.matches(context)) {
            StringDiagnostic message = new StringDiagnostic("Library class " + context.toSourceString() + (clazz.isInterface() ? " implements " : " extends ") + "program class " + type.toSourceString());
            if (this.tracingMainDex || this.forceProguardCompatibility) {
                this.options.reporter.warning(message);
            } else {
                this.options.reporter.error(message);
            }
        }
    }

    private void reportMissingClass(DexType clazz) {
    }

    private void reportMissingMethod(DexMethod method) {
    }

    private void reportMissingField(DexField field) {
    }

    private void markMethodAsTargeted(DexEncodedMethod method, KeepReason reason) {
        if (!this.targetedMethods.add(method, reason)) {
            return;
        }
        this.markTypeAsLive(method.method.holder);
        this.markParameterAndReturnTypesAsLive(method);
        if (this.appView.definitionFor(method.method.holder).isProgramClass()) {
            this.processAnnotations(method, method.annotations.annotations);
            method.parameterAnnotationsList.forEachAnnotation(annotation -> this.processAnnotation(method, (DexAnnotation)annotation));
        }
        if (this.forceProguardCompatibility) {
            DexClass clazz = this.appView.definitionFor(method.method.holder);
            if (!method.accessFlags.isAbstract() && clazz.isInterface() && clazz.isProgramClass()) {
                this.markMethodAsKeptWithCompatRule(method);
            }
        }
    }

    private void processNewlyInstantiatedClass(DexClass clazz, KeepReason reason) {
        if (!this.instantiatedTypes.add(clazz.type, reason)) {
            return;
        }
        this.collectProguardCompatibilityRule(reason);
        this.markTypeAsLive(clazz.type);
        this.transitionMethodsForInstantiatedClass(clazz.type);
        this.transitionFieldsForInstantiatedClass(clazz.type);
        this.enqueueRootItems(this.rootSet.getDependentItems(clazz));
    }

    private void transitionMethodsForInstantiatedClass(DexType instantiatedType) {
        DexClass clazz;
        ScopedDexMethodSet seen = new ScopedDexMethodSet();
        Set<DexType> interfaces = Sets.newIdentityHashSet();
        DexType type = instantiatedType;
        do {
            if ((clazz = this.appView.definitionFor(type)) == null) {
                this.reportMissingClass(type);
                break;
            }
            SetWithReason<DexEncodedMethod> reachableMethods = this.reachableVirtualMethods.get(type);
            if (reachableMethods != null) {
                this.transitionNonAbstractMethodsToLiveAndShadow(reachableMethods.getItems(), instantiatedType, seen);
            }
            Collections.addAll(interfaces, clazz.interfaces.values);
        } while ((type = clazz.superType) != null && !this.instantiatedTypes.contains(type));
        for (DexType iface : interfaces) {
            DexClass clazz2 = this.appView.definitionFor(iface);
            if (clazz2 == null) {
                this.reportMissingClass(iface);
                break;
            }
            this.transitionDefaultMethodsForInstantiatedClass(iface, instantiatedType, seen);
        }
    }

    private void transitionDefaultMethodsForInstantiatedClass(DexType iface, DexType instantiatedType, ScopedDexMethodSet seen) {
        DexClass clazz = this.appView.definitionFor(iface);
        if (clazz == null) {
            this.reportMissingClass(iface);
            return;
        }
        assert (clazz.accessFlags.isInterface());
        SetWithReason<DexEncodedMethod> reachableMethods = this.reachableVirtualMethods.get(iface);
        if (reachableMethods != null) {
            this.transitionNonAbstractMethodsToLiveAndShadow(reachableMethods.getItems(), instantiatedType, seen.newNestedScope());
        }
        for (DexType subInterface : clazz.interfaces.values) {
            this.transitionDefaultMethodsForInstantiatedClass(subInterface, instantiatedType, seen);
        }
    }

    private void transitionNonAbstractMethodsToLiveAndShadow(Iterable<DexEncodedMethod> reachable, DexType instantiatedType, ScopedDexMethodSet seen) {
        for (DexEncodedMethod encodedMethod : reachable) {
            if (!seen.addMethod(encodedMethod) || encodedMethod.accessFlags.isAbstract()) continue;
            this.markVirtualMethodAsLive(encodedMethod, KeepReason.reachableFromLiveType(instantiatedType));
        }
    }

    private void transitionFieldsForInstantiatedClass(DexType type) {
        DexClass clazz;
        do {
            if ((clazz = this.appView.definitionFor(type)) == null) {
                this.reportMissingClass(type);
                break;
            }
            if (!clazz.isProgramClass()) break;
            SetWithReason<DexEncodedField> reachableFields = this.reachableInstanceFields.get(type);
            if (reachableFields == null) continue;
            for (DexEncodedField field : reachableFields.getItems()) {
                this.markInstanceFieldAsLive(field, KeepReason.reachableFromLiveType(type));
            }
        } while ((type = clazz.superType) != null && !this.instantiatedTypes.contains(type));
    }

    private void markStaticFieldAsLive(DexField field, KeepReason reason) {
        this.markStaticFieldAsLive(field, reason, this.appInfo.resolveField(field));
    }

    private void markStaticFieldAsLive(DexField field, KeepReason reason, DexEncodedField encodedField) {
        this.markTypeAsLive(field.holder);
        this.markTypeAsLive(field.type);
        if (encodedField == null) {
            this.reportMissingField(field);
            return;
        }
        if (!encodedField.isProgramField(this.appView)) {
            return;
        }
        if (encodedField.accessFlags.isStatic()) {
            // empty if block
        }
        this.processAnnotations(encodedField, encodedField.annotations.annotations);
        this.liveFields.add(encodedField, reason);
        this.collectProguardCompatibilityRule(reason);
        this.enqueueRootItems(this.rootSet.getDependentItems(encodedField));
    }

    private void markInstanceFieldAsLive(DexEncodedField field, KeepReason reason) {
        assert (field != null);
        assert (field.isProgramField(this.appView));
        this.markTypeAsLive(field.field.holder);
        this.markTypeAsLive(field.field.type);
        this.processAnnotations(field, field.annotations.annotations);
        this.liveFields.add(field, reason);
        this.collectProguardCompatibilityRule(reason);
        this.enqueueRootItems(this.rootSet.getDependentItems(field));
    }

    private void markInstantiated(DexType type, KeepReason keepReason) {
        if (this.instantiatedTypes.contains(type)) {
            return;
        }
        DexClass clazz = this.appView.definitionFor(type);
        if (clazz == null) {
            this.reportMissingClass(type);
            return;
        }
        this.workList.add(Action.markInstantiated(clazz, keepReason));
    }

    private void markLambdaInstantiated(DexType itf, DexEncodedMethod method) {
        DexClass clazz = this.appView.definitionFor(itf);
        if (clazz == null) {
            if (this.options.reporter != null) {
                StringDiagnostic message = new StringDiagnostic("Lambda expression implements missing interface `" + itf.toSourceString() + "`", this.appInfo.originFor(method.method.holder));
                this.options.reporter.warning(message);
            }
            return;
        }
        if (!clazz.isInterface()) {
            if (this.options.reporter != null) {
                StringDiagnostic message = new StringDiagnostic("Lambda expression expected to implement an interface, but found `" + itf.toSourceString() + "`", this.appInfo.originFor(method.method.holder));
                this.options.reporter.warning(message);
            }
            return;
        }
        if (clazz.isProgramClass()) {
            this.instantiatedLambdas.add(itf, KeepReason.instantiatedIn(method));
        }
    }

    private void markDirectStaticOrConstructorMethodAsLive(DexEncodedMethod encodedMethod, KeepReason reason) {
        assert (encodedMethod != null);
        this.markMethodAsTargeted(encodedMethod, reason);
        if (!this.liveMethods.contains(encodedMethod)) {
            this.markTypeAsLive(encodedMethod.method.holder);
            this.workList.add(Action.markMethodLive(encodedMethod, reason));
        }
    }

    private void markVirtualMethodAsLive(DexEncodedMethod method, KeepReason reason) {
        assert (method != null);
        assert (!method.accessFlags.isAbstract() || reason.isDueToKeepRule() || reason.isDueToReflectiveUse());
        if (!this.liveMethods.contains(method)) {
            this.workList.add(Action.markMethodLive(method, reason));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInstantiatedOrHasInstantiatedSubtype(DexType type) {
        if (this.instantiatedTypes.contains(type)) return true;
        if (!this.appInfo.subtypes(type).stream().anyMatch(this.instantiatedTypes::contains)) return false;
        return true;
    }

    private void markInstanceFieldAsReachable(DexField field, KeepReason reason) {
        DexEncodedField encodedField = this.appInfo.resolveField(field);
        if (encodedField == null) {
            this.reportMissingField(field);
            return;
        }
        if (!encodedField.isProgramField(this.appView)) {
            return;
        }
        if (encodedField.accessFlags.isStatic()) {
            this.markStaticFieldAsLive(encodedField.field, reason);
        } else if (this.isInstantiatedOrHasInstantiatedSubtype(encodedField.field.holder)) {
            this.markInstanceFieldAsLive(encodedField, reason);
        } else {
            this.reachableInstanceFields.computeIfAbsent(encodedField.field.holder, ignore -> Enqueuer.newSetWithoutReasonReporter()).add(encodedField, reason);
        }
    }

    private void markVirtualMethodAsReachable(DexMethod method, boolean interfaceInvoke, KeepReason reason) {
        this.markVirtualMethodAsReachable(method, interfaceInvoke, reason, null);
    }

    private void markVirtualMethodAsReachable(DexMethod method, boolean interfaceInvoke, KeepReason reason, Consumer<DexEncodedMethod> possibleTargetsConsumer) {
        DexEncodedMethod topTarget;
        if (!this.virtualTargetsMarkedAsReachable.add(method)) {
            return;
        }
        if (method.holder.isArrayType()) {
            this.markTypeAsLive(method.holder);
            return;
        }
        DexClass holder = this.appView.definitionFor(method.holder);
        if (holder == null) {
            this.reportMissingClass(method.holder);
            return;
        }
        DexEncodedMethod dexEncodedMethod = topTarget = interfaceInvoke ? this.appInfo.resolveMethodOnInterface(method.holder, method).asResultOfResolve() : this.appInfo.resolveMethodOnClass(method.holder, method).asResultOfResolve();
        if (topTarget == null) {
            this.reportMissingMethod(method);
            return;
        }
        this.markMethodAsTargeted(topTarget, reason);
        Set<DexEncodedMethod> possibleTargets = interfaceInvoke ? this.appInfo.lookupInterfaceTargets(method) : this.appInfo.lookupVirtualTargets(method);
        block0: for (DexEncodedMethod encodedMethod : possibleTargets) {
            SetWithReason reachable = this.reachableVirtualMethods.computeIfAbsent(encodedMethod.method.holder, ignore -> Enqueuer.newSetWithoutReasonReporter());
            if (!reachable.add(encodedMethod, reason) || encodedMethod.accessFlags.isAbstract() || !this.isInstantiatedOrHasInstantiatedSubtype(encodedMethod.method.holder)) continue;
            if (this.instantiatedTypes.contains(encodedMethod.method.holder)) {
                this.markVirtualMethodAsLive(encodedMethod, KeepReason.reachableFromLiveType(encodedMethod.method.holder));
                continue;
            }
            ArrayDeque<DexType> worklist = new ArrayDeque<DexType>();
            this.fillWorkList(worklist, encodedMethod.method.holder);
            while (!worklist.isEmpty()) {
                DexType current = (DexType)worklist.pollFirst();
                DexClass currentHolder = this.appView.definitionFor(current);
                if (currentHolder == null || currentHolder.lookupVirtualMethod(encodedMethod.method) != null) continue;
                if (this.instantiatedTypes.contains(current)) {
                    this.markVirtualMethodAsLive(encodedMethod, KeepReason.reachableFromLiveType(current));
                    continue block0;
                }
                this.fillWorkList(worklist, current);
            }
        }
        if (possibleTargetsConsumer != null) {
            possibleTargets.forEach(possibleTargetsConsumer);
        }
    }

    private DexMethod generatedEnumValuesMethod(DexClass enumClass) {
        DexType arrayOfEnumClass = this.appView.dexItemFactory().createType(this.appView.dexItemFactory().createString("[" + enumClass.type.toDescriptorString()));
        DexProto proto = this.appView.dexItemFactory().createProto(arrayOfEnumClass, new DexType[0]);
        return this.appView.dexItemFactory().createMethod(enumClass.type, proto, this.appView.dexItemFactory().createString("values"));
    }

    private void markEnumValuesAsReachable(DexClass clazz, KeepReason reason) {
        DexEncodedMethod valuesMethod = clazz.lookupMethod(this.generatedEnumValuesMethod(clazz));
        if (valuesMethod != null) {
            this.enqueueRootItem((DexDefinition)valuesMethod, reason);
            this.rootSet.shouldNotBeMinified(valuesMethod.toReference());
        }
    }

    private void fillWorkList(Deque<DexType> worklist, DexType type) {
        if (this.appInfo.isMarkedAsInterface(type)) {
            this.appInfo.forAllImplementsSubtypes(type, worklist::addLast);
            this.appInfo.forAllExtendsSubtypes(type, worklist::addLast);
        } else {
            this.appInfo.forAllExtendsSubtypes(type, worklist::addLast);
        }
    }

    private void markSuperMethodAsReachable(DexMethod method, DexEncodedMethod from) {
        DexEncodedMethod resolutionTarget = this.appInfo.resolveMethod(method.holder, method).asResultOfResolve();
        if (resolutionTarget == null) {
            this.brokenSuperInvokes.add(method);
            this.reportMissingMethod(method);
            return;
        }
        if (resolutionTarget.accessFlags.isPrivate() || resolutionTarget.accessFlags.isStatic()) {
            this.brokenSuperInvokes.add(method);
        }
        this.markMethodAsTargeted(resolutionTarget, KeepReason.targetedBySuperFrom(from));
        DexEncodedMethod target = this.appInfo.lookupSuperTarget(method, from.method.holder);
        if (target == null) {
            this.reportMissingMethod(method);
            return;
        }
        if (target.accessFlags.isPrivate()) {
            this.brokenSuperInvokes.add(method);
        }
        if (this.superInvokeDependencies.computeIfAbsent(from, ignore -> Sets.newIdentityHashSet()).add(target) && this.liveMethods.contains(from)) {
            this.markMethodAsTargeted(target, KeepReason.invokedViaSuperFrom(from));
            if (!target.accessFlags.isAbstract()) {
                this.markVirtualMethodAsLive(target, KeepReason.invokedViaSuperFrom(from));
            }
        }
    }

    public SortedSet<DexType> traceMainDex(RootSetBuilder.RootSet rootSet, ExecutorService executorService, Timing timing) throws ExecutionException {
        this.tracingMainDex = true;
        this.rootSet = rootSet;
        this.enqueueRootItems(rootSet.noShrinking);
        this.trace(executorService, timing);
        this.options.reporter.failIfPendingErrors();
        return ImmutableSortedSet.copyOf(PresortedComparable::slowCompareTo, this.liveTypes);
    }

    public AppInfoWithLiveness traceApplication(RootSetBuilder.RootSet rootSet, ProguardClassFilter dontWarnPatterns, ExecutorService executorService, Timing timing) throws ExecutionException {
        this.rootSet = rootSet;
        this.dontWarnPatterns = dontWarnPatterns;
        this.enqueueRootItems(rootSet.noShrinking);
        TopDownClassHierarchyTraversal.forLibraryClasses(this.appView).visit((Iterable)this.appView.appInfo().classes(), this::markAllLibraryVirtualMethodsReachable);
        this.trace(executorService, timing);
        this.options.reporter.failIfPendingErrors();
        return Enqueuer.createAppInfo(this.appInfo, this);
    }

    private static AppInfoWithLiveness createAppInfo(AppInfoWithSubtyping appInfo, Enqueuer enqueuer) {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.orderedBy(PresortedComparable::slowCompareTo);
        ((SetWithReason)enqueuer.liveAnnotations).items.forEach(annotation -> builder.add(annotation.annotation.type));
        SortedMap<DexField, Set<DexEncodedMethod>> instanceFieldReads = enqueuer.collectDescriptors(enqueuer.instanceFieldsRead);
        SortedMap<DexField, Set<DexEncodedMethod>> instanceFieldWrites = enqueuer.collectDescriptors(enqueuer.instanceFieldsWritten);
        SortedMap<DexField, Set<DexEncodedMethod>> staticFieldReads = enqueuer.collectDescriptors(enqueuer.staticFieldsRead);
        SortedMap<DexField, Set<DexEncodedMethod>> staticFieldWrites = enqueuer.collectDescriptors(enqueuer.staticFieldsWritten);
        AppInfoWithLiveness appInfoWithLiveness = new AppInfoWithLiveness(appInfo, ImmutableSortedSet.copyOf(PresortedComparable::slowCompareTo, enqueuer.liveTypes), (SortedSet<DexType>)((Object)builder.build()), ImmutableSortedSet.copyOf(PresortedComparable::slowCompareTo, enqueuer.instantiatedAppServices), ImmutableSortedSet.copyOf(PresortedComparable::slowCompareTo, enqueuer.instantiatedTypes.getItems()), Enqueuer.toSortedDescriptorSet(enqueuer.targetedMethods.getItems()), ImmutableSortedSet.copyOf(DexMethod::slowCompareTo, enqueuer.bootstrapMethods), ImmutableSortedSet.copyOf(DexMethod::slowCompareTo, enqueuer.methodsTargetedByInvokeDynamic), ImmutableSortedSet.copyOf(DexMethod::slowCompareTo, enqueuer.virtualMethodsTargetedByInvokeDirect), Enqueuer.toSortedDescriptorSet(enqueuer.liveMethods.getItems()), EnqueuerUtils.extractProgramFieldDefinitions(instanceFieldReads.keySet(), staticFieldReads.keySet(), appInfo, field -> !enqueuer.pinnedItems.contains(field.field)), EnqueuerUtils.extractProgramFieldDefinitions(instanceFieldWrites.keySet(), staticFieldWrites.keySet(), appInfo, field -> !enqueuer.pinnedItems.contains(field.field)), ImmutableSortedSet.copyOf(DexField::slowCompareTo, enqueuer.staticFieldsWrittenOnlyInEnclosingStaticInitializer()), instanceFieldReads, instanceFieldWrites, staticFieldReads, staticFieldWrites, enqueuer.collectDescriptors(enqueuer.virtualInvokes), enqueuer.collectDescriptors(enqueuer.interfaceInvokes), enqueuer.collectDescriptors(enqueuer.superInvokes), enqueuer.collectDescriptors(enqueuer.directInvokes), enqueuer.collectDescriptors(enqueuer.staticInvokes), enqueuer.callSites, ImmutableSortedSet.copyOf(DexMethod::slowCompareTo, enqueuer.brokenSuperInvokes), enqueuer.pinnedItems, enqueuer.rootSet.mayHaveSideEffects, enqueuer.rootSet.noSideEffects, enqueuer.rootSet.assumedValues, enqueuer.rootSet.alwaysInline, enqueuer.rootSet.forceInline, enqueuer.rootSet.neverInline, enqueuer.rootSet.keepConstantArguments, enqueuer.rootSet.keepUnusedArguments, enqueuer.rootSet.neverClassInline, enqueuer.rootSet.neverMerge, enqueuer.rootSet.neverPropagateValue, Enqueuer.joinIdentifierNameStrings(enqueuer.rootSet.identifierNameStrings, enqueuer.identifierNameStrings), Collections.emptySet(), Collections.emptyMap(), Collections.emptyMap(), ImmutableSortedSet.copyOf(PresortedComparable::slowCompareTo, enqueuer.instantiatedLambdas.getItems()));
        appInfo.markObsolete();
        return appInfoWithLiveness;
    }

    private static <T extends PresortedComparable<T>> SortedSet<T> toSortedDescriptorSet(Set<? extends KeyedDexItem<T>> set) {
        ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(PresortedComparable::slowCompareTo);
        for (KeyedDexItem<T> item : set) {
            builder.add(item.getKey());
        }
        return builder.build();
    }

    private static Object2BooleanMap<DexReference> joinIdentifierNameStrings(Set<DexReference> explicit, Set<DexReference> implicit) {
        Object2BooleanArrayMap<DexReference> result = new Object2BooleanArrayMap<DexReference>();
        for (DexReference e : explicit) {
            result.putIfAbsent(e, true);
        }
        for (DexReference i : implicit) {
            result.putIfAbsent(i, false);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trace(ExecutorService executorService, Timing timing) throws ExecutionException {
        timing.begin("Grow the tree.");
        try {
            while (true) {
                long numOfLiveItems = this.liveTypes.size();
                numOfLiveItems += (long)((SetWithReason)this.liveMethods).items.size();
                numOfLiveItems += (long)((SetWithReason)this.liveFields).items.size();
                block14: while (!this.workList.isEmpty()) {
                    Action action = this.workList.poll();
                    switch (action.kind) {
                        case MARK_INSTANTIATED: {
                            this.processNewlyInstantiatedClass((DexClass)action.target, action.reason);
                            continue block14;
                        }
                        case MARK_REACHABLE_FIELD: {
                            this.markInstanceFieldAsReachable((DexField)action.target, action.reason);
                            continue block14;
                        }
                        case MARK_REACHABLE_VIRTUAL: {
                            this.markVirtualMethodAsReachable((DexMethod)action.target, false, action.reason);
                            continue block14;
                        }
                        case MARK_REACHABLE_INTERFACE: {
                            this.markVirtualMethodAsReachable((DexMethod)action.target, true, action.reason);
                            continue block14;
                        }
                        case MARK_REACHABLE_SUPER: {
                            this.markSuperMethodAsReachable((DexMethod)action.target, (DexEncodedMethod)action.context);
                            continue block14;
                        }
                        case MARK_METHOD_KEPT: {
                            this.markMethodAsKept((DexEncodedMethod)action.target, action.reason);
                            continue block14;
                        }
                        case MARK_FIELD_KEPT: {
                            this.markFieldAsKept((DexEncodedField)action.target, action.reason);
                            continue block14;
                        }
                        case MARK_METHOD_LIVE: {
                            this.processNewlyLiveMethod((DexEncodedMethod)action.target, action.reason);
                            continue block14;
                        }
                    }
                    throw new IllegalArgumentException(action.kind.toString());
                }
                long numOfLiveItemsAfterProcessing = this.liveTypes.size();
                numOfLiveItemsAfterProcessing += (long)((SetWithReason)this.liveMethods).items.size();
                if ((numOfLiveItemsAfterProcessing += (long)((SetWithReason)this.liveFields).items.size()) > numOfLiveItems) {
                    RootSetBuilder consequentSetBuilder = new RootSetBuilder(this.appView, this.rootSet.ifRules);
                    RootSetBuilder.IfRuleEvaluator ifRuleEvaluator = consequentSetBuilder.getIfRuleEvaluator(this.liveFields.getItems(), this.liveMethods.getItems(), this.targetedMethods.getItems(), executorService);
                    RootSetBuilder.ConsequentRootSet consequentRootSet = ifRuleEvaluator.run(this.liveTypes);
                    this.rootSet.addConsequentRootSet(consequentRootSet);
                    this.enqueueRootItems(consequentRootSet.noShrinking);
                    consequentRootSet.dependentNoShrinking.forEach((precondition, dependentItems) -> {
                        if (precondition.isDexType()) {
                            DexClass preconditionHolder = this.appView.definitionFor(precondition.asDexType());
                            this.enqueueHolderIfDependentNonStaticMember(preconditionHolder, (Map<DexReference, Set<ProguardKeepRule>>)dependentItems);
                        }
                        this.enqueueRootItems((Map<DexReference, Set<ProguardKeepRule>>)dependentItems);
                    });
                    if (!this.workList.isEmpty()) continue;
                }
                if (this.proguardCompatibilityWorkList.isEmpty() && this.pendingReflectiveUses.isEmpty()) break;
                this.pendingReflectiveUses.forEach(this::handleReflectiveBehavior);
                this.workList.addAll(this.proguardCompatibilityWorkList);
                this.proguardCompatibilityWorkList.clear();
                this.pendingReflectiveUses.clear();
            }
            assert (this.liveTypes.stream().allMatch(DexType::isClassType));
            assert (this.instantiatedTypes.getItems().stream().allMatch(DexType::isClassType));
        }
        finally {
            timing.end();
        }
        this.unpinLambdaMethods();
    }

    private void unpinLambdaMethods() {
        for (DexMethod method : this.lambdaMethodsTargetedByInvokeDynamic) {
            this.pinnedItems.remove(method);
            this.rootSet.prune(method);
        }
        this.lambdaMethodsTargetedByInvokeDynamic.clear();
    }

    private void markMethodAsKept(DexEncodedMethod target, KeepReason reason) {
        DexClass holder = this.appView.definitionFor(target.method.holder);
        if (holder == null) {
            return;
        }
        if (target.isVirtualMethod()) {
            this.markVirtualMethodAsReachable(target.method, holder.accessFlags.isInterface(), reason);
            if (holder.isInterface() && target.isVirtualMethod()) {
                if (target.isNonAbstractVirtualMethod()) {
                    this.markVirtualMethodAsLive(target, reason);
                } else {
                    DexEncodedMethod implementation = target.getDefaultInterfaceMethodImplementation();
                    if (implementation != null) {
                        DexClass companion = this.appView.definitionFor(implementation.method.holder);
                        this.markTypeAsLive(companion.type);
                        this.markVirtualMethodAsLive(implementation, reason);
                    }
                }
            }
        } else {
            this.markDirectStaticOrConstructorMethodAsLive(target, reason);
        }
    }

    private void markFieldAsKept(DexEncodedField target, KeepReason reason) {
        if (this.appView.definitionFor(target.field.holder) == null) {
            return;
        }
        if (target.accessFlags.isStatic()) {
            this.markStaticFieldAsLive(target.field, reason);
        } else {
            this.markInstanceFieldAsReachable(target.field, reason);
        }
    }

    private void markAllLibraryVirtualMethodsReachable(DexLibraryClass clazz) {
        for (DexEncodedMethod encodedMethod : clazz.virtualMethods()) {
            this.markMethodAsTargeted(encodedMethod, KeepReason.isLibraryMethod());
            this.markVirtualMethodAsReachable(encodedMethod.method, clazz.isInterface(), KeepReason.isLibraryMethod(), DexEncodedMethod::setLibraryMethodOverride);
        }
    }

    private void processNewlyLiveMethod(DexEncodedMethod method, KeepReason reason) {
        if (this.liveMethods.add(method, reason)) {
            this.collectProguardCompatibilityRule(reason);
            DexClass holder = this.appView.definitionFor(method.method.holder);
            assert (holder != null);
            if (holder.isNotProgramClass()) {
                return;
            }
            Set<DexEncodedMethod> superCallTargets = this.superInvokeDependencies.get(method);
            if (superCallTargets != null) {
                for (DexEncodedMethod superCallTarget : superCallTargets) {
                    this.markMethodAsTargeted(superCallTarget, KeepReason.invokedViaSuperFrom(method));
                    this.markVirtualMethodAsLive(superCallTarget, KeepReason.invokedViaSuperFrom(method));
                }
            }
            this.markParameterAndReturnTypesAsLive(method);
            if (this.appView.definitionFor(method.method.holder).isProgramClass()) {
                this.processAnnotations(method, method.annotations.annotations);
                method.parameterAnnotationsList.forEachAnnotation(annotation -> this.processAnnotation(method, (DexAnnotation)annotation));
            }
            method.registerCodeReferences(new UseRegistry(this.options.itemFactory, method));
            this.enqueueRootItems(this.rootSet.getDependentItems(method));
        }
    }

    private void markParameterAndReturnTypesAsLive(DexEncodedMethod method) {
        for (DexType parameterType : method.method.proto.parameters.values) {
            this.markTypeAsLive(parameterType);
        }
        this.markTypeAsLive(method.method.proto.returnType);
    }

    private void collectProguardCompatibilityRule(KeepReason reason) {
        if (reason.isDueToProguardCompatibility() && this.compatibility != null) {
            this.compatibility.addRule(reason.getProguardKeepRule());
        }
    }

    private <T extends Descriptor<?, T>> SortedMap<T, Set<DexEncodedMethod>> collectDescriptors(Map<DexType, Set<TargetWithContext<T>>> map2) {
        TreeMap<Descriptor, Set> result = new TreeMap<Descriptor, Set>(PresortedComparable::slowCompare);
        for (Map.Entry<DexType, Set<TargetWithContext<T>>> entry : map2.entrySet()) {
            for (TargetWithContext<T> descriptorWithContext : entry.getValue()) {
                T descriptor = descriptorWithContext.getTarget();
                DexEncodedMethod context = descriptorWithContext.getContext();
                result.computeIfAbsent((Descriptor)descriptor, k -> Sets.newIdentityHashSet()).add(context);
            }
        }
        return Collections.unmodifiableSortedMap(result);
    }

    private void markClassAsInstantiatedWithReason(DexClass clazz, KeepReason reason) {
        assert (clazz.isProgramClass());
        this.workList.add(Action.markInstantiated(clazz, reason));
        if (clazz.hasDefaultInitializer()) {
            this.workList.add(Action.markMethodLive(clazz.getDefaultInitializer(), reason));
        }
    }

    private void markClassAsInstantiatedWithCompatRule(DexClass clazz) {
        ProguardKeepRule rule = ProguardConfigurationUtils.buildDefaultInitializerKeepRule(clazz);
        this.proguardCompatibilityWorkList.add(Action.markInstantiated(clazz, KeepReason.dueToProguardCompatibilityKeepRule(rule)));
        if (clazz.hasDefaultInitializer()) {
            this.proguardCompatibilityWorkList.add(Action.markMethodLive(clazz.getDefaultInitializer(), KeepReason.dueToProguardCompatibilityKeepRule(rule)));
        }
    }

    private void markMethodAsKeptWithCompatRule(DexEncodedMethod method) {
        DexClass holderClass = this.appView.definitionFor(method.method.holder);
        ProguardKeepRule rule = ProguardConfigurationUtils.buildMethodKeepRule(holderClass, method);
        this.proguardCompatibilityWorkList.add(Action.markMethodLive(method, KeepReason.dueToProguardCompatibilityKeepRule(rule)));
    }

    private void handleReflectiveBehavior(DexEncodedMethod method) {
        DexType originHolder = method.method.holder;
        Origin origin = this.appInfo.originFor(originHolder);
        IRCode code = method.buildIR(this.appView, origin);
        InstructionIterator iterator2 = code.instructionIterator();
        while (iterator2.hasNext()) {
            Instruction instruction = (Instruction)iterator2.next();
            this.handleReflectiveBehavior(method, instruction);
        }
    }

    private void handleReflectiveBehavior(DexEncodedMethod method, Instruction instruction) {
        if (!instruction.isInvokeMethod()) {
            return;
        }
        InvokeMethod invoke = instruction.asInvokeMethod();
        DexMethod invokedMethod = invoke.getInvokedMethod();
        DexItemFactory dexItemFactory = this.appView.dexItemFactory();
        if (invokedMethod == dexItemFactory.classMethods.newInstance) {
            this.handleJavaLangClassNewInstance(method, invoke);
            return;
        }
        if (invokedMethod == dexItemFactory.constructorMethods.newInstance) {
            this.handleJavaLangReflectConstructorNewInstance(method, invoke);
            return;
        }
        if (invokedMethod == dexItemFactory.enumMethods.valueOf) {
            this.handleJavaLangEnumValueOf(method, invoke);
            return;
        }
        if (invokedMethod == dexItemFactory.proxyMethods.newProxyInstance) {
            this.handleJavaLangReflectProxyNewProxyInstance(method, invoke);
            return;
        }
        if (dexItemFactory.serviceLoaderMethods.isLoadMethod(invokedMethod)) {
            this.handleServiceLoaderInvocation(method, invoke);
            return;
        }
        if (!IdentifierNameStringUtils.isReflectionMethod(dexItemFactory, invokedMethod)) {
            return;
        }
        DexReference identifierItem = IdentifierNameStringUtils.identifyIdentifier(invoke, this.appView);
        if (identifierItem == null) {
            return;
        }
        if (identifierItem.isDexType()) {
            DexClass clazz = this.appView.definitionFor(identifierItem.asDexType());
            if (clazz != null) {
                this.markInstantiated(clazz.type, KeepReason.reflectiveUseIn(method));
                if (clazz.hasDefaultInitializer()) {
                    this.markDirectStaticOrConstructorMethodAsLive(clazz.getDefaultInitializer(), KeepReason.reflectiveUseIn(method));
                }
            }
        } else if (identifierItem.isDexField()) {
            DexEncodedField encodedField = this.appView.definitionFor(identifierItem.asDexField());
            if (encodedField != null) {
                boolean keepClass;
                boolean bl = keepClass = !encodedField.accessFlags.isStatic() && dexItemFactory.atomicFieldUpdaterMethods.isFieldUpdater(invokedMethod);
                if (keepClass) {
                    DexClass holderClass = this.appView.definitionFor(encodedField.field.holder);
                    this.markInstantiated(holderClass.type, KeepReason.reflectiveUseIn(method));
                }
                this.markFieldAsKept(encodedField, KeepReason.reflectiveUseIn(method));
                if (encodedField.isStatic()) {
                    this.registerItemWithTargetAndContext(this.staticFieldsRead, encodedField.field, method);
                    this.registerItemWithTargetAndContext(this.staticFieldsWritten, encodedField.field, method);
                } else {
                    this.registerItemWithTargetAndContext(this.instanceFieldsRead, encodedField.field, method);
                    this.registerItemWithTargetAndContext(this.instanceFieldsWritten, encodedField.field, method);
                }
            }
        } else {
            assert (identifierItem.isDexMethod());
            DexEncodedMethod encodedMethod = this.appView.definitionFor(identifierItem.asDexMethod());
            if (encodedMethod != null) {
                if (encodedMethod.accessFlags.isStatic() || encodedMethod.accessFlags.isConstructor()) {
                    this.markDirectStaticOrConstructorMethodAsLive(encodedMethod, KeepReason.reflectiveUseIn(method));
                } else {
                    this.markVirtualMethodAsLive(encodedMethod, KeepReason.reflectiveUseIn(method));
                }
            }
        }
    }

    private void handleJavaLangClassNewInstance(DexEncodedMethod method, InvokeMethod invoke) {
        DexEncodedMethod defaultInitializer;
        if (!invoke.isInvokeVirtual()) {
            assert (false);
            return;
        }
        DexType instantiatedType = ConstantValueUtils.getDexTypeRepresentedByValue(invoke.asInvokeVirtual().getReceiver(), this.appView);
        if (instantiatedType == null || !instantiatedType.isClassType()) {
            return;
        }
        DexClass clazz = this.appView.definitionFor(instantiatedType);
        if (clazz != null && clazz.isProgramClass() && (defaultInitializer = clazz.getDefaultInitializer()) != null) {
            KeepReason reason = KeepReason.reflectiveUseIn(method);
            this.markClassAsInstantiatedWithReason(clazz, reason);
            this.markDirectStaticOrConstructorMethodAsLive(defaultInitializer, reason);
        }
    }

    private void handleJavaLangReflectConstructorNewInstance(DexEncodedMethod method, InvokeMethod invoke) {
        if (!invoke.isInvokeVirtual()) {
            assert (false);
            return;
        }
        Value constructorValue = invoke.asInvokeVirtual().getReceiver().getAliasedValue();
        if (constructorValue.isPhi() || !constructorValue.definition.isInvokeVirtual()) {
            return;
        }
        InvokeVirtual constructorDefinition = constructorValue.definition.asInvokeVirtual();
        if (constructorDefinition.getInvokedMethod() != this.appView.dexItemFactory().classMethods.getDeclaredConstructor) {
            return;
        }
        DexType instantiatedType = ConstantValueUtils.getDexTypeRepresentedByValue(constructorDefinition.getReceiver(), this.appView);
        if (instantiatedType == null || !instantiatedType.isClassType()) {
            return;
        }
        DexClass clazz = this.appView.definitionFor(instantiatedType);
        if (clazz != null && clazz.isProgramClass()) {
            Value parametersValue = constructorDefinition.inValues().get(1);
            if (parametersValue.isPhi() || !parametersValue.definition.isNewArrayEmpty()) {
                return;
            }
            Value parametersSizeValue = parametersValue.definition.asNewArrayEmpty().size();
            if (parametersSizeValue.isPhi() || !parametersSizeValue.definition.isConstNumber()) {
                return;
            }
            DexEncodedMethod initializer = null;
            int parametersSize = parametersSizeValue.definition.asConstNumber().getIntValue();
            if (parametersSize == 0) {
                initializer = clazz.getDefaultInitializer();
            } else {
                DexType[] parameterTypes = new DexType[parametersSize];
                int missingIndices = parametersSize;
                for (Instruction user : parametersValue.uniqueUsers()) {
                    if (!user.isArrayPut()) continue;
                    ArrayPut arrayPutInstruction = user.asArrayPut();
                    if (arrayPutInstruction.array() != parametersValue) {
                        return;
                    }
                    Value indexValue = arrayPutInstruction.index();
                    if (indexValue.isPhi() || !indexValue.definition.isConstNumber()) {
                        return;
                    }
                    int index = indexValue.definition.asConstNumber().getIntValue();
                    if (index >= parametersSize) {
                        return;
                    }
                    DexType type = ConstantValueUtils.getDexTypeRepresentedByValue(arrayPutInstruction.value(), this.appView);
                    if (type == null) {
                        return;
                    }
                    if (parameterTypes[index] == type) continue;
                    if (parameterTypes[index] != null) {
                        return;
                    }
                    parameterTypes[index] = type;
                    --missingIndices;
                }
                if (missingIndices == 0) {
                    initializer = clazz.getInitializer(parameterTypes);
                }
            }
            if (initializer != null) {
                KeepReason reason = KeepReason.reflectiveUseIn(method);
                this.markClassAsInstantiatedWithReason(clazz, reason);
                this.markDirectStaticOrConstructorMethodAsLive(initializer, reason);
            }
        }
    }

    private void handleJavaLangReflectProxyNewProxyInstance(DexEncodedMethod method, InvokeMethod invoke) {
        if (!invoke.isInvokeStatic()) {
            assert (false);
            return;
        }
        Value interfacesValue = invoke.arguments().get(1);
        if (interfacesValue.isPhi() || !interfacesValue.definition.isNewArrayEmpty()) {
            return;
        }
        for (Instruction user : interfacesValue.uniqueUsers()) {
            DexClass clazz;
            ArrayPut arrayPut;
            DexType type;
            if (!user.isArrayPut() || (type = ConstantValueUtils.getDexTypeRepresentedByValue((arrayPut = user.asArrayPut()).value(), this.appView)) == null || !type.isClassType() || (clazz = this.appView.definitionFor(type)) == null || !clazz.isProgramClass() || !clazz.isInterface()) continue;
            this.pinnedItems.add(clazz.type);
        }
    }

    private void handleJavaLangEnumValueOf(DexEncodedMethod method, InvokeMethod invoke) {
        if (invoke.inValues().get(0).isConstClass()) {
            DexClass clazz = this.appView.definitionFor(invoke.inValues().get((int)0).definition.asConstClass().getValue());
            if (clazz.accessFlags.isEnum() && clazz.superType == this.appView.dexItemFactory().enumType) {
                this.markEnumValuesAsReachable(clazz, KeepReason.invokedFrom(method));
            }
        }
    }

    private void handleServiceLoaderInvocation(DexEncodedMethod method, InvokeMethod invoke) {
        if (invoke.inValues().size() == 0) {
            return;
        }
        Value argument = invoke.inValues().get(0).getAliasedValue();
        if (!argument.isPhi() && argument.definition.isConstClass()) {
            DexType serviceType = argument.definition.asConstClass().getValue();
            if (!this.appView.appServices().allServiceTypes().contains(serviceType)) {
                return;
            }
            this.handleServiceInstantiation(serviceType, KeepReason.reflectiveUseIn(method));
        } else {
            KeepReason reason = KeepReason.reflectiveUseIn(method);
            for (DexType serviceType : this.appView.appServices().allServiceTypes()) {
                this.handleServiceInstantiation(serviceType, reason);
            }
        }
    }

    private void handleServiceInstantiation(DexType serviceType, KeepReason reason) {
        this.instantiatedAppServices.add(serviceType);
        List<DexType> serviceImplementationTypes = this.appView.appServices().serviceImplementationsFor(serviceType);
        for (DexType serviceImplementationType : serviceImplementationTypes) {
            DexClass serviceImplementationClass;
            if (!serviceImplementationType.isClassType() || (serviceImplementationClass = this.appView.definitionFor(serviceImplementationType)) == null || !serviceImplementationClass.isProgramClass()) continue;
            this.markClassAsInstantiatedWithReason(serviceImplementationClass, reason);
        }
    }

    private void registerType(DexType type, KeepReason reason) {
        assert (this.getSourceNode(reason) != null);
        if (this.keptGraphConsumer == null) {
            return;
        }
        this.registerEdge(this.getClassGraphNode(type), reason);
    }

    private void registerAnnotation(DexAnnotation annotation, KeepReason reason) {
        assert (this.getSourceNode(reason) != null);
        if (this.keptGraphConsumer == null) {
            return;
        }
        this.registerEdge(this.getAnnotationGraphNode(annotation.annotation.type), reason);
    }

    private void registerMethod(DexEncodedMethod method, KeepReason reason) {
        if (reason.edgeKind() == GraphEdgeInfo.EdgeKind.IsLibraryMethod) {
            return;
        }
        assert (this.getSourceNode(reason) != null);
        if (this.keptGraphConsumer == null) {
            return;
        }
        this.registerEdge(this.getMethodGraphNode(method.method), reason);
    }

    private void registerField(DexEncodedField field, KeepReason reason) {
        assert (this.getSourceNode(reason) != null);
        if (this.keptGraphConsumer == null) {
            return;
        }
        this.registerEdge(this.getFieldGraphNode(field.field), reason);
    }

    private void registerEdge(GraphNode target, KeepReason reason) {
        GraphNode sourceNode = this.getSourceNode(reason);
        if (!sourceNode.isLibraryNode()) {
            this.keptGraphConsumer.acceptEdge(sourceNode, target, this.getEdgeInfo(reason));
        }
    }

    private GraphNode getSourceNode(KeepReason reason) {
        return reason.getSourceNode(this);
    }

    public GraphNode getGraphNode(DexReference reference) {
        if (reference.isDexType()) {
            return this.getClassGraphNode(reference.asDexType());
        }
        if (reference.isDexMethod()) {
            return this.getMethodGraphNode(reference.asDexMethod());
        }
        if (reference.isDexField()) {
            return this.getFieldGraphNode(reference.asDexField());
        }
        throw new Unreachable();
    }

    GraphEdgeInfo getEdgeInfo(KeepReason reason) {
        return this.reasonInfo.computeIfAbsent(reason.edgeKind(), k -> new GraphEdgeInfo((GraphEdgeInfo.EdgeKind)((Object)k)));
    }

    AnnotationGraphNode getAnnotationGraphNode(DexItem type) {
        return this.annotationNodes.computeIfAbsent(type, t -> {
            if (t instanceof DexType) {
                return new AnnotationGraphNode(this.getClassGraphNode((DexType)t));
            }
            throw new Unimplemented("Incomplete support for annotation node on item: " + type.getClass());
        });
    }

    ClassGraphNode getClassGraphNode(DexType type) {
        return this.classNodes.computeIfAbsent(type, t -> {
            DexClass definition = this.appView.definitionFor((DexType)t);
            return new ClassGraphNode(definition != null && definition.isNotProgramClass(), Reference.classFromDescriptor(t.toDescriptorString()));
        });
    }

    MethodGraphNode getMethodGraphNode(DexMethod context) {
        return this.methodNodes.computeIfAbsent(context, m -> {
            DexClass holderDefinition = this.appView.definitionFor(context.holder);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (DexType param : m.proto.parameters.values) {
                builder.add(Reference.typeFromDescriptor(param.toDescriptorString()));
            }
            return new MethodGraphNode(holderDefinition != null && holderDefinition.isNotProgramClass(), Reference.method(Reference.classFromDescriptor(m.holder.toDescriptorString()), m.name.toString(), (List<TypeReference>)((Object)builder.build()), m.proto.returnType.isVoidType() ? null : Reference.typeFromDescriptor(m.proto.returnType.toDescriptorString())));
        });
    }

    FieldGraphNode getFieldGraphNode(DexField context) {
        return this.fieldNodes.computeIfAbsent(context, f -> {
            DexClass holderDefinition = this.appView.definitionFor(context.holder);
            return new FieldGraphNode(holderDefinition != null && holderDefinition.isNotProgramClass(), Reference.field(Reference.classFromDescriptor(f.holder.toDescriptorString()), f.name.toString(), Reference.typeFromDescriptor(f.type.toDescriptorString())));
        });
    }

    KeepRuleGraphNode getKeepRuleGraphNode(ProguardKeepRule rule) {
        return this.ruleNodes.computeIfAbsent(rule, KeepRuleGraphNode::new);
    }

    private class AnnotationReferenceMarker
    implements IndexedItemCollection {
        private final DexItem annotationHolder;
        private final DexItemFactory dexItemFactory;

        private AnnotationReferenceMarker(DexItem annotationHolder, DexItemFactory dexItemFactory) {
            this.annotationHolder = annotationHolder;
            this.dexItemFactory = dexItemFactory;
        }

        @Override
        public boolean addClass(DexProgramClass dexProgramClass) {
            return false;
        }

        @Override
        public boolean addField(DexField field) {
            DexClass holder = Enqueuer.this.appView.definitionFor(field.holder);
            if (holder == null) {
                return false;
            }
            DexEncodedField target = holder.lookupStaticField(field);
            if (target != null) {
                if (target.field == field) {
                    Enqueuer.this.markStaticFieldAsLive(field, KeepReason.referencedInAnnotation(this.annotationHolder));
                }
            } else {
                target = holder.lookupInstanceField(field);
                if (target != null && target.field != field) {
                    Enqueuer.this.markInstanceFieldAsReachable(field, KeepReason.referencedInAnnotation(this.annotationHolder));
                }
            }
            return false;
        }

        @Override
        public boolean addMethod(DexMethod method) {
            DexClass holder = Enqueuer.this.appView.definitionFor(method.holder);
            if (holder == null) {
                return false;
            }
            DexEncodedMethod target = holder.lookupDirectMethod(method);
            if (target != null) {
                if (target.method == method) {
                    Enqueuer.this.markDirectStaticOrConstructorMethodAsLive(target, KeepReason.referencedInAnnotation(this.annotationHolder));
                }
            } else {
                target = holder.lookupVirtualMethod(method);
                if (target != null && target.method == method) {
                    Enqueuer.this.markMethodAsTargeted(target, KeepReason.referencedInAnnotation(this.annotationHolder));
                }
            }
            return false;
        }

        @Override
        public boolean addString(DexString string) {
            return false;
        }

        @Override
        public boolean addProto(DexProto proto) {
            return false;
        }

        @Override
        public boolean addCallSite(DexCallSite callSite) {
            return false;
        }

        @Override
        public boolean addMethodHandle(DexMethodHandle methodHandle) {
            return false;
        }

        @Override
        public boolean addType(DexType type) {
            if (type != this.dexItemFactory.voidType) {
                Enqueuer.this.markTypeAsLive(type);
            }
            return false;
        }
    }

    private static final class TargetWithContext<T extends Descriptor<?, T>> {
        private final T target;
        private final DexEncodedMethod context;

        private TargetWithContext(T target, DexEncodedMethod context) {
            this.target = target;
            this.context = context;
        }

        public T getTarget() {
            return this.target;
        }

        public DexEncodedMethod getContext() {
            return this.context;
        }

        public int hashCode() {
            return ((CachedHashValueDexItem)this.target).hashCode() * 31 + this.context.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TargetWithContext)) {
                return false;
            }
            TargetWithContext other = (TargetWithContext)obj;
            return this.target == other.target && this.context == other.context;
        }

        /* synthetic */ TargetWithContext(Descriptor x0, DexEncodedMethod x1, 1 x2) {
            this(x0, x1);
        }
    }

    private static class SetWithReason<T> {
        private final Set<T> items = Sets.newIdentityHashSet();
        private final BiConsumer<T, KeepReason> register;

        public SetWithReason(BiConsumer<T, KeepReason> register) {
            this.register = register;
        }

        boolean add(T item, KeepReason reason) {
            this.register.accept(item, reason);
            return this.items.add(item);
        }

        boolean contains(T item) {
            return this.items.contains(item);
        }

        Set<T> getItems() {
            return ImmutableSet.copyOf(this.items);
        }
    }

    private static class Action {
        final Kind kind;
        final DexItem target;
        final DexItem context;
        final KeepReason reason;

        private Action(Kind kind, DexItem target, DexItem context, KeepReason reason) {
            this.kind = kind;
            this.target = target;
            this.context = context;
            this.reason = reason;
        }

        public static Action markReachableVirtual(DexMethod method, KeepReason reason) {
            return new Action(Kind.MARK_REACHABLE_VIRTUAL, method, null, reason);
        }

        public static Action markReachableInterface(DexMethod method, KeepReason reason) {
            return new Action(Kind.MARK_REACHABLE_INTERFACE, method, null, reason);
        }

        public static Action markReachableSuper(DexMethod method, DexEncodedMethod from) {
            return new Action(Kind.MARK_REACHABLE_SUPER, method, from, null);
        }

        public static Action markReachableField(DexField field, KeepReason reason) {
            return new Action(Kind.MARK_REACHABLE_FIELD, field, null, reason);
        }

        public static Action markInstantiated(DexClass clazz, KeepReason reason) {
            return new Action(Kind.MARK_INSTANTIATED, clazz, null, reason);
        }

        public static Action markMethodLive(DexEncodedMethod method, KeepReason reason) {
            return new Action(Kind.MARK_METHOD_LIVE, method, null, reason);
        }

        public static Action markMethodKept(DexEncodedMethod method, KeepReason reason) {
            return new Action(Kind.MARK_METHOD_KEPT, method, null, reason);
        }

        public static Action markFieldKept(DexEncodedField field, KeepReason reason) {
            return new Action(Kind.MARK_FIELD_KEPT, field, null, reason);
        }

        private static enum Kind {
            MARK_REACHABLE_VIRTUAL,
            MARK_REACHABLE_INTERFACE,
            MARK_REACHABLE_SUPER,
            MARK_REACHABLE_FIELD,
            MARK_INSTANTIATED,
            MARK_METHOD_LIVE,
            MARK_METHOD_KEPT,
            MARK_FIELD_KEPT;

        }
    }

    private class UseRegistry
    extends com.android.tools.r8.graph.UseRegistry {
        private final DexEncodedMethod currentMethod;

        private UseRegistry(DexItemFactory factory, DexEncodedMethod currentMethod) {
            super(factory);
            this.currentMethod = currentMethod;
        }

        @Override
        public boolean registerInvokeVirtual(DexMethod method) {
            return this.registerInvokeVirtual(method, KeepReason.invokedFrom(this.currentMethod));
        }

        boolean registerInvokeVirtual(DexMethod method, KeepReason keepReason) {
            if (method == ((Enqueuer)Enqueuer.this).appView.dexItemFactory().classMethods.newInstance || method == ((Enqueuer)Enqueuer.this).appView.dexItemFactory().constructorMethods.newInstance) {
                Enqueuer.this.pendingReflectiveUses.add(this.currentMethod);
            } else if (((Enqueuer)Enqueuer.this).appView.dexItemFactory().classMethods.isReflectiveMemberLookup(method)) {
                Enqueuer.this.identifierNameStrings.add(method);
                Enqueuer.this.pendingReflectiveUses.add(this.currentMethod);
            }
            if (!Enqueuer.this.registerItemWithTargetAndContext(Enqueuer.this.virtualInvokes, method, this.currentMethod)) {
                return false;
            }
            Enqueuer.this.workList.add(Action.markReachableVirtual(method, keepReason));
            return true;
        }

        @Override
        public boolean registerInvokeDirect(DexMethod method) {
            return this.registerInvokeDirect(method, KeepReason.invokedFrom(this.currentMethod));
        }

        boolean registerInvokeDirect(DexMethod method, KeepReason keepReason) {
            if (!Enqueuer.this.registerItemWithTargetAndContext(Enqueuer.this.directInvokes, method, this.currentMethod)) {
                return false;
            }
            Enqueuer.this.handleInvokeOfDirectTarget(method, keepReason);
            return true;
        }

        @Override
        public boolean registerInvokeStatic(DexMethod method) {
            return this.registerInvokeStatic(method, KeepReason.invokedFrom(this.currentMethod));
        }

        boolean registerInvokeStatic(DexMethod method, KeepReason keepReason) {
            DexItemFactory dexItemFactory = Enqueuer.this.appView.dexItemFactory();
            if (method == dexItemFactory.classMethods.forName || dexItemFactory.atomicFieldUpdaterMethods.isFieldUpdater(method)) {
                Enqueuer.this.identifierNameStrings.add(method);
                Enqueuer.this.pendingReflectiveUses.add(this.currentMethod);
            }
            if (method == dexItemFactory.enumMethods.valueOf) {
                Enqueuer.this.pendingReflectiveUses.add(this.currentMethod);
            }
            if (dexItemFactory.serviceLoaderMethods.isLoadMethod(method)) {
                Enqueuer.this.pendingReflectiveUses.add(this.currentMethod);
            }
            if (method == dexItemFactory.proxyMethods.newProxyInstance) {
                Enqueuer.this.pendingReflectiveUses.add(this.currentMethod);
            }
            if (!Enqueuer.this.registerItemWithTargetAndContext(Enqueuer.this.staticInvokes, method, this.currentMethod)) {
                return false;
            }
            Enqueuer.this.handleInvokeOfStaticTarget(method, keepReason);
            return true;
        }

        @Override
        public boolean registerInvokeInterface(DexMethod method) {
            return this.registerInvokeInterface(method, KeepReason.invokedFrom(this.currentMethod));
        }

        boolean registerInvokeInterface(DexMethod method, KeepReason keepReason) {
            if (!Enqueuer.this.registerItemWithTargetAndContext(Enqueuer.this.interfaceInvokes, method, this.currentMethod)) {
                return false;
            }
            Enqueuer.this.workList.add(Action.markReachableInterface(method, keepReason));
            return true;
        }

        @Override
        public boolean registerInvokeSuper(DexMethod method) {
            DexMethod actualTarget = Enqueuer.this.getInvokeSuperTarget(method, this.currentMethod);
            if (!Enqueuer.this.registerItemWithTargetAndContext(Enqueuer.this.superInvokes, method, this.currentMethod)) {
                return false;
            }
            Enqueuer.this.workList.add(Action.markReachableSuper(method, this.currentMethod));
            return true;
        }

        @Override
        public boolean registerInstanceFieldWrite(DexField field) {
            if (!Enqueuer.this.registerItemWithTargetAndContext(Enqueuer.this.instanceFieldsWritten, field, this.currentMethod)) {
                return false;
            }
            Enqueuer.this.workList.add(Action.markReachableField(field, KeepReason.fieldReferencedIn(this.currentMethod)));
            return true;
        }

        @Override
        public boolean registerInstanceFieldRead(DexField field) {
            if (!Enqueuer.this.registerItemWithTargetAndContext(Enqueuer.this.instanceFieldsRead, field, this.currentMethod)) {
                return false;
            }
            Enqueuer.this.workList.add(Action.markReachableField(field, KeepReason.fieldReferencedIn(this.currentMethod)));
            return true;
        }

        @Override
        public boolean registerNewInstance(DexType type) {
            return this.registerNewInstance(type, KeepReason.instantiatedIn(this.currentMethod));
        }

        public boolean registerNewInstance(DexType type, KeepReason keepReason) {
            Enqueuer.this.markInstantiated(type, keepReason);
            return true;
        }

        @Override
        public boolean registerStaticFieldRead(DexField field) {
            if (!Enqueuer.this.registerItemWithTargetAndContext(Enqueuer.this.staticFieldsRead, field, this.currentMethod)) {
                return false;
            }
            Enqueuer.this.markStaticFieldAsLive(field, KeepReason.fieldReferencedIn(this.currentMethod));
            return true;
        }

        @Override
        public boolean registerStaticFieldWrite(DexField field) {
            if (!Enqueuer.this.registerItemWithTargetAndContext(Enqueuer.this.staticFieldsWritten, field, this.currentMethod)) {
                return false;
            }
            DexEncodedField encodedField = Enqueuer.this.appInfo.resolveField(field);
            if (encodedField != null && encodedField.isProgramField(Enqueuer.this.appView)) {
                boolean isWrittenOutsideEnclosingStaticInitializer;
                boolean bl = isWrittenOutsideEnclosingStaticInitializer = this.currentMethod.method.holder != encodedField.field.holder || !this.currentMethod.isClassInitializer();
                if (isWrittenOutsideEnclosingStaticInitializer) {
                    Enqueuer.this.staticFieldsWrittenOutsideEnclosingStaticInitializer.add(encodedField.field);
                }
            }
            Enqueuer.this.markStaticFieldAsLive(field, KeepReason.fieldReferencedIn(this.currentMethod), encodedField);
            return true;
        }

        @Override
        public boolean registerConstClass(DexType type) {
            return this.registerConstClassOrCheckCast(type);
        }

        @Override
        public boolean registerCheckCast(DexType type) {
            return this.registerConstClassOrCheckCast(type);
        }

        @Override
        public boolean registerTypeReference(DexType type) {
            Enqueuer.this.markTypeAsLive(type);
            return true;
        }

        @Override
        public void registerMethodHandle(DexMethodHandle methodHandle, UseRegistry.MethodHandleUse use) {
            DexClass holder;
            super.registerMethodHandle(methodHandle, use);
            if (methodHandle.isMethodHandle() && use != UseRegistry.MethodHandleUse.ARGUMENT_TO_LAMBDA_METAFACTORY && (holder = Enqueuer.this.appView.definitionFor(methodHandle.asMethod().holder)) != null) {
                Enqueuer.this.markInstantiated(holder.type, KeepReason.methodHandleReferencedIn(this.currentMethod));
            }
        }

        @Override
        public void registerCallSite(DexCallSite callSite) {
            LambdaDescriptor descriptor;
            DexClass bootstrapClass;
            Enqueuer.this.callSites.add(callSite);
            super.registerCallSite(callSite);
            List<DexType> directInterfaces = LambdaDescriptor.getInterfaces(callSite, Enqueuer.this.appInfo);
            if (directInterfaces != null) {
                for (DexType lambdaInstantiatedInterface : directInterfaces) {
                    Enqueuer.this.markLambdaInstantiated(lambdaInstantiatedInterface, this.currentMethod);
                }
            } else if (!Enqueuer.this.appInfo.isStringConcat(callSite.bootstrapMethod) && ((Enqueuer)Enqueuer.this).options.reporter != null) {
                StringDiagnostic message = new StringDiagnostic("Unknown bootstrap method " + callSite.bootstrapMethod, Enqueuer.this.appInfo.originFor(this.currentMethod.method.holder));
                ((Enqueuer)Enqueuer.this).options.reporter.warning(message);
            }
            if ((bootstrapClass = Enqueuer.this.appView.definitionFor(callSite.bootstrapMethod.asMethod().holder)) != null && bootstrapClass.isProgramClass()) {
                Enqueuer.this.bootstrapMethods.add(callSite.bootstrapMethod.asMethod());
            }
            if ((descriptor = LambdaDescriptor.tryInfer(callSite, Enqueuer.this.appInfo)) == null) {
                return;
            }
            DexMethodHandle implHandle = descriptor.implHandle;
            assert (implHandle != null);
            DexMethod method = implHandle.asMethod();
            if (descriptor.delegatesToLambdaImplMethod()) {
                Enqueuer.this.lambdaMethodsTargetedByInvokeDynamic.add(method);
            }
            if (!Enqueuer.this.methodsTargetedByInvokeDynamic.add(method)) {
                return;
            }
            switch (implHandle.type) {
                case INVOKE_STATIC: {
                    this.registerInvokeStatic(method, KeepReason.invokedFromLambdaCreatedIn(this.currentMethod));
                    break;
                }
                case INVOKE_INTERFACE: {
                    this.registerInvokeInterface(method, KeepReason.invokedFromLambdaCreatedIn(this.currentMethod));
                    break;
                }
                case INVOKE_INSTANCE: {
                    this.registerInvokeVirtual(method, KeepReason.invokedFromLambdaCreatedIn(this.currentMethod));
                    break;
                }
                case INVOKE_DIRECT: {
                    this.registerInvokeDirect(method, KeepReason.invokedFromLambdaCreatedIn(this.currentMethod));
                    break;
                }
                case INVOKE_CONSTRUCTOR: {
                    this.registerNewInstance(method.holder, KeepReason.invokedFromLambdaCreatedIn(this.currentMethod));
                    break;
                }
                default: {
                    throw new Unreachable();
                }
            }
            ScopedDexMethodSet seen = new ScopedDexMethodSet();
            if (directInterfaces == null) {
                return;
            }
            HashSet<DexType> allInterfaces = Sets.newHashSet(directInterfaces);
            DexType instantiatedType = ((Enqueuer)Enqueuer.this).appView.dexItemFactory().objectType;
            DexClass clazz = Enqueuer.this.appView.definitionFor(instantiatedType);
            if (clazz == null) {
                Enqueuer.this.reportMissingClass(instantiatedType);
                return;
            }
            SetWithReason reachableMethods = (SetWithReason)Enqueuer.this.reachableVirtualMethods.get(instantiatedType);
            if (reachableMethods != null) {
                Enqueuer.this.transitionNonAbstractMethodsToLiveAndShadow(reachableMethods.getItems(), instantiatedType, seen);
            }
            Collections.addAll(allInterfaces, clazz.interfaces.values);
            for (DexType iface : allInterfaces) {
                DexClass ifaceClazz = Enqueuer.this.appView.definitionFor(iface);
                if (ifaceClazz == null) {
                    Enqueuer.this.reportMissingClass(iface);
                    return;
                }
                Enqueuer.this.transitionDefaultMethodsForInstantiatedClass(iface, instantiatedType, seen);
            }
        }

        private boolean registerConstClassOrCheckCast(DexType type) {
            if (Enqueuer.this.forceProguardCompatibility) {
                DexType baseType = type.toBaseType(Enqueuer.this.appView.dexItemFactory());
                if (baseType.isClassType()) {
                    DexClass baseClass = Enqueuer.this.appView.definitionFor(baseType);
                    if (baseClass != null && baseClass.isProgramClass()) {
                        Enqueuer.this.markClassAsInstantiatedWithCompatRule(baseClass);
                    } else {
                        Enqueuer.this.markTypeAsLive(baseType);
                    }
                    return true;
                }
                return false;
            }
            return this.registerTypeReference(type);
        }
    }
}

