/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableSortedSet;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.PresortedComparable;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Predicate;

class EnqueuerUtils {
    EnqueuerUtils() {
    }

    static SortedSet<DexField> extractProgramFieldDefinitions(Set<DexField> instanceFields, Set<DexField> staticFields, AppInfo appInfo, Predicate<DexEncodedField> predicate) {
        return EnqueuerUtils.extractFieldDefinitions(instanceFields, staticFields, appInfo, field -> field.isProgramField(appInfo) && predicate.test((DexEncodedField)field));
    }

    static SortedSet<DexField> extractFieldDefinitions(Set<DexField> instanceFields, Set<DexField> staticFields, AppInfo appInfo, Predicate<DexEncodedField> predicate) {
        DexEncodedField encodedField;
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.orderedBy(PresortedComparable::slowCompareTo);
        for (DexField field : instanceFields) {
            encodedField = appInfo.resolveField(field);
            if (encodedField == null || !predicate.test(encodedField)) continue;
            builder.add(encodedField.field);
        }
        for (DexField field : staticFields) {
            encodedField = appInfo.resolveField(field);
            if (encodedField == null || !predicate.test(encodedField)) continue;
            builder.add(encodedField.field);
        }
        return builder.build();
    }
}

