/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.shaking.ProguardAccessFlags;
import com.android.tools.r8.shaking.ProguardClassNameList;
import com.android.tools.r8.shaking.ProguardClassSpecification;
import com.android.tools.r8.shaking.ProguardClassType;
import com.android.tools.r8.shaking.ProguardMemberRule;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import com.android.tools.r8.shaking.ProguardWildcard;
import com.android.tools.r8.utils.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.StreamSupport;

public abstract class ProguardConfigurationRule
extends ProguardClassSpecification {
    ProguardConfigurationRule(Origin origin, Position position, String source, ProguardTypeMatcher classAnnotation, ProguardAccessFlags classAccessFlags, ProguardAccessFlags negatedClassAccessFlags, boolean classTypeNegated, ProguardClassType classType, ProguardClassNameList classNames, ProguardTypeMatcher inheritanceAnnotation, ProguardTypeMatcher inheritanceClassName, boolean inheritanceIsExtends, List<ProguardMemberRule> memberRules) {
        super(origin, position, source, classAnnotation, classAccessFlags, negatedClassAccessFlags, classTypeNegated, classType, classNames, inheritanceAnnotation, inheritanceClassName, inheritanceIsExtends, memberRules);
    }

    abstract String typeString();

    String modifierString() {
        return null;
    }

    public boolean applyToNonProgramClasses() {
        return false;
    }

    protected Iterable<ProguardWildcard> getWildcards() {
        List<ProguardMemberRule> memberRules = this.getMemberRules();
        Iterable[] iterableArray = new Iterable[5];
        iterableArray[0] = ProguardTypeMatcher.getWildcardsOrEmpty(this.getClassAnnotation());
        iterableArray[1] = ProguardClassNameList.getWildcardsOrEmpty(this.getClassNames());
        iterableArray[2] = ProguardTypeMatcher.getWildcardsOrEmpty(this.getInheritanceAnnotation());
        iterableArray[3] = ProguardTypeMatcher.getWildcardsOrEmpty(this.getInheritanceClassName());
        iterableArray[4] = memberRules != null ? memberRules.stream().map(ProguardMemberRule::getWildcards).flatMap(it -> StreamSupport.stream(it.spliterator(), false))::iterator : Collections::emptyIterator;
        return Iterables.concat(iterableArray);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ProguardConfigurationRule)) {
            return false;
        }
        ProguardConfigurationRule that = (ProguardConfigurationRule)o;
        return super.equals(that);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    protected StringBuilder append(StringBuilder builder, boolean includeMemberRules) {
        builder.append("-");
        builder.append(this.typeString());
        StringUtils.appendNonEmpty(builder, ",", this.modifierString(), null);
        builder.append(' ');
        super.append(builder, includeMemberRules);
        return builder;
    }
}

