/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.utils.LongInterval;

public class ProguardMemberRuleReturnValue {
    private final Type type;
    private final boolean booleanValue;
    private final LongInterval longInterval;
    private final DexField field;

    ProguardMemberRuleReturnValue(boolean value) {
        this.type = Type.BOOLEAN;
        this.booleanValue = value;
        this.longInterval = null;
        this.field = null;
    }

    ProguardMemberRuleReturnValue(LongInterval value) {
        this.type = Type.VALUE_RANGE;
        this.booleanValue = false;
        this.longInterval = value;
        this.field = null;
    }

    ProguardMemberRuleReturnValue(DexField field) {
        this.type = Type.FIELD;
        this.booleanValue = false;
        this.longInterval = null;
        this.field = field;
    }

    ProguardMemberRuleReturnValue() {
        this.type = Type.NULL;
        this.booleanValue = false;
        this.longInterval = null;
        this.field = null;
    }

    public boolean isBoolean() {
        return this.type == Type.BOOLEAN;
    }

    public boolean isValueRange() {
        return this.type == Type.VALUE_RANGE;
    }

    public boolean isField() {
        return this.type == Type.FIELD;
    }

    public boolean isNull() {
        return this.type == Type.NULL;
    }

    public boolean getBoolean() {
        assert (this.isBoolean());
        return this.booleanValue;
    }

    public boolean isSingleValue() {
        return this.isBoolean() || this.isNull() || this.isValueRange() && this.longInterval.isSingleValue();
    }

    public long getSingleValue() {
        assert (this.isSingleValue());
        if (this.isBoolean()) {
            return this.booleanValue ? 1L : 0L;
        }
        if (this.isNull()) {
            return 0L;
        }
        return this.longInterval.getSingleValue();
    }

    public LongInterval getValueRange() {
        assert (this.isValueRange());
        return this.longInterval;
    }

    public DexField getField() {
        assert (this.isField());
        return this.field;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(" return ");
        if (this.isBoolean()) {
            result.append(this.booleanValue ? "true" : "false");
        } else if (this.isNull()) {
            result.append("null");
        } else if (this.isValueRange()) {
            result.append(this.longInterval.getMin());
            if (!this.isSingleValue()) {
                result.append("..");
                result.append(this.longInterval.getMax());
            }
        } else {
            assert (this.isField());
            result.append(this.field.holder.toSourceString() + '.' + this.field.name);
        }
        return result.toString();
    }

    public static enum Type {
        BOOLEAN,
        VALUE_RANGE,
        FIELD,
        NULL;

    }
}

