/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.KeyedDexItem;
import com.android.tools.r8.graph.PresortedComparable;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.ProguardConfiguration;
import com.android.tools.r8.shaking.UsagePrinter;
import com.android.tools.r8.utils.InternalOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class TreePruner {
    private final DexApplication application;
    private final AppView<AppInfoWithLiveness> appView;
    private final UsagePrinter usagePrinter;
    private final Set<DexType> prunedTypes = Sets.newIdentityHashSet();

    public TreePruner(DexApplication application, AppView<AppInfoWithLiveness> appView) {
        this.application = application;
        this.appView = appView;
        ProguardConfiguration proguardConfiguration = appView.options().getProguardConfiguration();
        this.usagePrinter = proguardConfiguration != null && proguardConfiguration.isPrintUsage() ? new UsagePrinter() : UsagePrinter.DONT_PRINT;
    }

    public DexApplication run() {
        DexApplication result;
        this.application.timing.begin("Pruning application...");
        try {
            result = ((DexApplication.Builder)this.removeUnused(this.application).appendDeadCode(this.usagePrinter.toStringContent())).build();
        }
        finally {
            this.application.timing.end();
        }
        return result;
    }

    private DexApplication.Builder<?> removeUnused(DexApplication application) {
        return application.builder().replaceProgramClasses(this.getNewProgramClasses(application.classes()));
    }

    private List<DexProgramClass> getNewProgramClasses(List<DexProgramClass> classes) {
        AppInfoWithLiveness appInfo = this.appView.appInfo();
        InternalOptions options = this.appView.options();
        ArrayList<DexProgramClass> newClasses = new ArrayList<DexProgramClass>();
        for (DexProgramClass clazz : classes) {
            if (options.configurationDebugging) {
                newClasses.add(clazz);
                this.pruneMembersAndAttributes(clazz);
                continue;
            }
            if (!appInfo.liveTypes.contains(clazz.type)) {
                this.prunedTypes.add(clazz.type);
                this.usagePrinter.printUnusedClass(clazz);
                continue;
            }
            newClasses.add(clazz);
            if (!appInfo.instantiatedTypes.contains(clazz.type) && !options.forceProguardCompatibility) {
                if (clazz.accessFlags.isFinal()) {
                    clazz.accessFlags.demoteFromFinal();
                }
                clazz.accessFlags.setAbstract();
            }
            this.pruneMembersAndAttributes(clazz);
        }
        return newClasses;
    }

    private void pruneMembersAndAttributes(DexProgramClass clazz) {
        DexEncodedField[] reachableStaticFields;
        DexEncodedField[] reachableInstanceFields;
        DexEncodedMethod[] reachableVirtualMethods;
        this.usagePrinter.visiting(clazz);
        DexEncodedMethod[] reachableDirectMethods = this.reachableMethods(clazz.directMethods(), clazz);
        if (reachableDirectMethods != null) {
            clazz.setDirectMethods(reachableDirectMethods);
        }
        if ((reachableVirtualMethods = this.reachableMethods(clazz.virtualMethods(), clazz)) != null) {
            clazz.setVirtualMethods(reachableVirtualMethods);
        }
        if ((reachableInstanceFields = this.reachableFields(clazz.instanceFields())) != null) {
            clazz.setInstanceFields(reachableInstanceFields);
        }
        if ((reachableStaticFields = this.reachableFields(clazz.staticFields())) != null) {
            clazz.setStaticFields(reachableStaticFields);
        }
        clazz.removeInnerClasses(this::isAttributeReferencingPrunedType);
        clazz.removeEnclosingMethod(this::isAttributeReferencingPrunedItem);
        this.usagePrinter.visited();
    }

    private boolean isAttributeReferencingPrunedItem(EnclosingMethodAttribute attr) {
        AppInfoWithLiveness appInfo = this.appView.appInfo();
        return attr.getEnclosingClass() != null && !appInfo.liveTypes.contains(attr.getEnclosingClass()) || attr.getEnclosingMethod() != null && !appInfo.liveMethods.contains(attr.getEnclosingMethod());
    }

    private boolean isAttributeReferencingPrunedType(InnerClassAttribute attr) {
        AppInfoWithLiveness appInfo = this.appView.appInfo();
        if (!appInfo.liveTypes.contains(attr.getInner())) {
            return true;
        }
        DexType context = attr.getLiveContext(appInfo);
        return context == null || !appInfo.liveTypes.contains(context);
    }

    private <S extends PresortedComparable<S>, T extends KeyedDexItem<S>> int firstUnreachableIndex(List<T> items, Predicate<S> live) {
        for (int i = 0; i < items.size(); ++i) {
            if (live.test(((KeyedDexItem)items.get(i)).getKey())) continue;
            return i;
        }
        return -1;
    }

    private DexEncodedMethod[] reachableMethods(List<DexEncodedMethod> methods, DexClass clazz) {
        int i;
        AppInfoWithLiveness appInfo = this.appView.appInfo();
        InternalOptions options = this.appView.options();
        int firstUnreachable = this.firstUnreachableIndex(methods, appInfo.liveMethods::contains);
        if (firstUnreachable == -1) {
            return null;
        }
        ArrayList<DexEncodedMethod> reachableMethods = new ArrayList<DexEncodedMethod>(methods.size());
        for (i = 0; i < firstUnreachable; ++i) {
            reachableMethods.add(methods.get(i));
        }
        for (i = firstUnreachable; i < methods.size(); ++i) {
            DexEncodedMethod method = methods.get(i);
            if (appInfo.liveMethods.contains(method.getKey())) {
                reachableMethods.add(method);
                continue;
            }
            if (options.configurationDebugging) {
                reachableMethods.add(method.shouldNotHaveCode() && !method.hasCode() ? method : method.toMethodThatLogsError(this.appView));
                continue;
            }
            if (appInfo.targetedMethods.contains(method.getKey())) {
                boolean allowAbstract;
                if (method.shouldNotHaveCode() && !method.hasCode()) {
                    reachableMethods.add(method);
                    continue;
                }
                boolean bl = allowAbstract = clazz.accessFlags.isAbstract() && !method.accessFlags.isFinal() && !method.accessFlags.isNative() && !method.accessFlags.isStrict() && !method.accessFlags.isSynchronized() && !method.accessFlags.isPrivate();
                reachableMethods.add(allowAbstract ? method.toAbstractMethod() : (options.isGeneratingClassFiles() ? method.toEmptyThrowingMethodCf() : method.toEmptyThrowingMethodDex()));
                continue;
            }
            this.usagePrinter.printUnusedMethod(method);
        }
        return reachableMethods.isEmpty() ? DexEncodedMethod.EMPTY_ARRAY : reachableMethods.toArray(DexEncodedMethod.EMPTY_ARRAY);
    }

    private DexEncodedField[] reachableFields(List<DexEncodedField> fields) {
        int i;
        AppInfoWithLiveness appInfo = this.appView.appInfo();
        Predicate<DexField> isReachableOrReferencedField = field -> appInfo.isFieldRead((DexField)field) || appInfo.isFieldWritten((DexField)field);
        int firstUnreachable = this.firstUnreachableIndex(fields, isReachableOrReferencedField);
        if (firstUnreachable == -1) {
            return null;
        }
        this.usagePrinter.printUnusedField(fields.get(firstUnreachable));
        ArrayList<DexEncodedField> reachableOrReferencedFields = new ArrayList<DexEncodedField>(fields.size());
        for (i = 0; i < firstUnreachable; ++i) {
            reachableOrReferencedFields.add(fields.get(i));
        }
        for (i = firstUnreachable + 1; i < fields.size(); ++i) {
            DexEncodedField field2 = fields.get(i);
            if (isReachableOrReferencedField.test(field2.field)) {
                reachableOrReferencedFields.add(field2);
                continue;
            }
            this.usagePrinter.printUnusedField(field2);
        }
        return reachableOrReferencedFields.isEmpty() ? DexEncodedField.EMPTY_ARRAY : reachableOrReferencedFields.toArray(DexEncodedField.EMPTY_ARRAY);
    }

    public Collection<DexType> getRemovedClasses() {
        return Collections.unmodifiableCollection(this.prunedTypes);
    }
}

