/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class ArrayUtils {
    public static <T> T[] copyWithSparseChanges(Class<T[]> clazz, T[] original, Map<Integer, T> changedElements) {
        T[] results = clazz.cast(Array.newInstance(clazz.getComponentType(), original.length));
        int pos = 0;
        for (Map.Entry<Integer, T> entry : changedElements.entrySet()) {
            int i = entry.getKey();
            System.arraycopy(original, pos, results, pos, i - pos);
            results[i] = entry.getValue();
            pos = i + 1;
        }
        if (pos < original.length) {
            System.arraycopy(original, pos, results, pos, original.length - pos);
        }
        return results;
    }

    public static <T> T[] filter(Class<T[]> clazz, T[] original, Predicate<T> filter) {
        ArrayList<T> filtered = null;
        for (int i = 0; i < original.length; ++i) {
            T elt = original[i];
            if (filter.test(elt)) {
                if (filtered == null) continue;
                filtered.add(elt);
                continue;
            }
            if (filtered != null) continue;
            filtered = new ArrayList<T>(original.length);
            for (int j = 0; j < i; ++j) {
                filtered.add(original[j]);
            }
        }
        if (filtered == null) {
            return original;
        }
        return filtered.toArray(clazz.cast(Array.newInstance(clazz.getComponentType(), filtered.size())));
    }

    public static <T> T[] map(Class<T[]> clazz, T[] original, Function<T, T> mapper) {
        ArrayList<T> results = null;
        for (int i = 0; i < original.length; ++i) {
            T oldOne = original[i];
            T newOne = mapper.apply(oldOne);
            if (newOne == oldOne) {
                if (results == null) continue;
                results.add(oldOne);
                continue;
            }
            if (results == null) {
                results = new ArrayList<T>(original.length);
                for (int j = 0; j < i; ++j) {
                    results.add(original[j]);
                }
            }
            if (newOne == null) continue;
            results.add(newOne);
        }
        if (results == null) {
            return original;
        }
        return results.toArray(clazz.cast(Array.newInstance(clazz.getComponentType(), results.size())));
    }
}

