/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.graph.KeyedDexItem;
import com.android.tools.r8.graph.PresortedComparable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class OrderedMergingIterator<T extends KeyedDexItem<S>, S extends PresortedComparable<S>>
implements Iterator<T> {
    private final List<T> one;
    private final List<T> other;
    private int oneIndex = 0;
    private int otherIndex = 0;

    public OrderedMergingIterator(List<T> one, List<T> other) {
        this.one = one;
        this.other = other;
    }

    private static <T> T getNextChecked(List<T> list, int position) {
        if (position >= list.size()) {
            throw new NoSuchElementException();
        }
        return list.get(position);
    }

    @Override
    public boolean hasNext() {
        return this.oneIndex < this.one.size() || this.otherIndex < this.other.size();
    }

    @Override
    public T next() {
        if (this.oneIndex >= this.one.size()) {
            return (T)((KeyedDexItem)OrderedMergingIterator.getNextChecked(this.other, this.otherIndex++));
        }
        if (this.otherIndex >= this.other.size()) {
            return (T)((KeyedDexItem)OrderedMergingIterator.getNextChecked(this.one, this.oneIndex++));
        }
        int comparison = ((KeyedDexItem)this.one.get(this.oneIndex)).getKey().compareTo(((KeyedDexItem)this.other.get(this.otherIndex)).getKey());
        if (comparison < 0) {
            return (T)((KeyedDexItem)this.one.get(this.oneIndex++));
        }
        if (comparison == 0) {
            throw new InternalCompilerError("Source arrays are not disjoint.");
        }
        return (T)((KeyedDexItem)this.other.get(this.otherIndex++));
    }
}

