/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.utils.StringUtils;
import java.util.Arrays;

public class SymbolGenerationUtils {
    private static final char[] IDENTIFIER_CHARACTERS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final int NUMBER_OF_CHARACTERS = IDENTIFIER_CHARACTERS.length;
    private static final int NUMBER_OF_CHARACTERS_MINUS_CAPITAL_LETTERS = NUMBER_OF_CHARACTERS - 26;
    private static final int NON_ALLOWED_FIRST_CHARACTERS = 10;

    public static String numberToIdentifier(int nameCount, MixedCasing mixedCasing) {
        return SymbolGenerationUtils.numberToIdentifier(nameCount, mixedCasing, StringUtils.EMPTY_CHAR_ARRAY, false);
    }

    public static String numberToIdentifier(int nameCount, MixedCasing mixedCasing, char[] prefix) {
        return SymbolGenerationUtils.numberToIdentifier(nameCount, mixedCasing, prefix, false);
    }

    public static String numberToIdentifier(int nameCount, MixedCasing mixedCasing, char[] prefix, boolean addSemicolon) {
        int firstNumberOfCharacters;
        int size = 1;
        int number = nameCount;
        int maximumNumberOfCharacters = mixedCasing == MixedCasing.USE_MIXED_CASE ? NUMBER_OF_CHARACTERS : NUMBER_OF_CHARACTERS_MINUS_CAPITAL_LETTERS;
        int availableCharacters = firstNumberOfCharacters = maximumNumberOfCharacters - 10;
        while (number > availableCharacters) {
            number = (number - 1) / availableCharacters;
            availableCharacters = maximumNumberOfCharacters;
            ++size;
        }
        char[] characters = Arrays.copyOfRange(prefix, 0, prefix.length + (size += addSemicolon ? 1 : 0));
        number = nameCount;
        int i = prefix.length;
        availableCharacters = firstNumberOfCharacters;
        int firstLetterPadding = 10;
        while (number > availableCharacters) {
            characters[i++] = IDENTIFIER_CHARACTERS[(number - 1) % availableCharacters + firstLetterPadding];
            number = (number - 1) / availableCharacters;
            availableCharacters = maximumNumberOfCharacters;
            firstLetterPadding = 0;
        }
        characters[i++] = IDENTIFIER_CHARACTERS[number - 1 + firstLetterPadding];
        if (addSemicolon) {
            characters[i++] = 59;
        }
        assert (i == characters.length);
        assert (!Character.isDigit(characters[prefix.length]));
        return new String(characters);
    }

    public static enum MixedCasing {
        USE_MIXED_CASE,
        DONT_USE_MIXED_CASE;

    }
}

