/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;

public class Timing {
    private final Stack<Node> stack = new Stack();

    public Timing() {
        this("<no title>");
    }

    public Timing(String title) {
        this.stack.push(new Node("Recorded timings for " + title));
    }

    public void begin(String title) {
        Node child;
        Node parent = this.stack.peek();
        if (parent.children.containsKey(title)) {
            child = parent.children.get(title);
            child.restart();
        } else {
            child = new Node(title);
            parent.children.put(title, child);
        }
        this.stack.push(child);
    }

    public void end() {
        this.stack.peek().end();
        this.stack.pop();
    }

    public void report() {
        Node top = this.stack.peek();
        top.end();
        System.out.println();
        top.report(0, top);
    }

    public void scope(String title, TimingScope fn) {
        this.begin(title);
        try {
            fn.apply();
        }
        finally {
            this.end();
        }
    }

    public static interface TimingScope {
        public void apply();
    }

    static class Node {
        final String title;
        final Map<String, Node> children = new LinkedHashMap<String, Node>();
        long duration = 0L;
        long start_time;

        Node(String title) {
            this.title = title;
            this.start_time = System.nanoTime();
        }

        void restart() {
            assert (this.start_time == -1L);
            this.start_time = System.nanoTime();
        }

        void end() {
            this.duration += System.nanoTime() - this.start_time;
            this.start_time = -1L;
            assert (this.duration() >= 0L);
        }

        long duration() {
            return this.duration;
        }

        public String toString() {
            return this.title + ": " + this.duration() / 1000000L + "ms.";
        }

        public String toString(Node top) {
            if (this == top) {
                return this.toString();
            }
            long percentage = this.duration() * 100L / top.duration();
            return this.toString() + " (" + percentage + "%)";
        }

        public void report(int depth, Node top) {
            assert (this.duration() >= 0L);
            if (depth > 0) {
                for (int i = 0; i < depth; ++i) {
                    System.out.print("  ");
                }
                System.out.print("- ");
            }
            System.out.println(this.toString(top));
            this.children.values().forEach(p -> p.report(depth + 1, top));
        }
    }
}

