package cos.mos.fragmenttransitionanimationtest;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;

import androidx.appcompat.app.AppCompatActivity;

public class MainActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        final AFragment aFragment = new AFragment();
        final BFragment bFragment = new BFragment();
        getSupportFragmentManager().beginTransaction().add(R.id.container, aFragment).add(R.id.container, bFragment).hide(bFragment).commit();
        Handler handler = new Handler(Looper.getMainLooper());
        handler.postDelayed(new Runnable() {
            @Override
            public void run() {
                getSupportFragmentManager().beginTransaction().setCustomAnimations(R.animator.enter, R.animator.exit).show(bFragment).hide(aFragment).commit();
            }
        }, 100);

        handler.postDelayed(new Runnable() {
            @Override
            public void run() {
                getSupportFragmentManager().beginTransaction().setCustomAnimations(R.animator.enter, R.animator.exit).show(aFragment).hide(bFragment).commit();
            }
        }, 500);
    }
}
