import org.jetbrains.kotlin.gradle.tasks.KotlinCompile

plugins {
    id("com.android.application")
    kotlin("android")
    kotlin("android.extensions")
}

android {
    buildToolsVersion("28.0.3")
    compileSdkVersion(28)

    defaultConfig {
        applicationId = "com.x"
        minSdkVersion(24)
        targetSdkVersion(28)

        versionCode = 1
        versionName = "0.1"
    }
    
    buildTypes {
        getByName("release") {
            isMinifyEnabled = false
            proguardFiles(getDefaultProguardFile("proguard-android.txt"), "proguard-rules.pro")
        }
    }
    
    sourceSets {
        getByName("main").java.srcDirs("src/main/kotlin")
    }
}

tasks.withType<KotlinCompile>().all {
    kotlinOptions {
        val experimentalAnnotations = listOf(
            "kotlinx.serialization.ImplicitReflectionSerializer"
        )
        freeCompilerArgs = freeCompilerArgs + "-Xuse-experimental=${experimentalAnnotations.joinToString(",")}"
    }
}

dependencies {
    val androidXVersion = "1.0.1"
    val androidKtxVersion = "2.2.0-alpha01"

    implementations()
    implementation(project(":common"))
    implementation("androidx.core:core-ktx:$androidXVersion")
    implementation("androidx.appcompat:appcompat:$androidXVersion")
    implementation("androidx.lifecycle:lifecycle-runtime-ktx:$androidKtxVersion")
    implementation("androidx.lifecycle:lifecycle-viewmodel-ktx:$androidKtxVersion")
}
