import org.jetbrains.kotlin.gradle.tasks.KotlinCompile

buildscript {
    repositories {
        jcenter()
        google()
        maven { setUrl("https://kotlin.bintray.com/kotlin-eap") }
    }

    dependencies {
        classpath("com.android.tools.build:gradle:3.4.1")
        classpath("org.jetbrains.kotlin:kotlin-gradle-plugin:${Version.Kotlin}")
        classpath("org.jetbrains.kotlin:kotlin-serialization:${Version.Kotlin}")
        classpath("mysql:mysql-connector-java:${Version.MySqlConnector}")
        classpath("org.jooq:jooq-codegen:${Version.Jooq}")
    }
}

allprojects {
    repositories {
        jcenter()
        google()
        mavenCentral()
        maven { setUrl("https://kotlin.bintray.com/kotlinx") }
        maven { setUrl("https://kotlin.bintray.com/kotlin-eap") }
    }
}

subprojects {
    if (listOf("common", "server", "android").contains(project.name)) {
        apply(plugin = "kotlinx-serialization")

        tasks {
            withType<KotlinCompile>().all {
                kotlinOptions {
                    val experimentalAnnotations = listOf(
                        "kotlinx.serialization.ImplicitReflectionSerializer",
                        "kotlinx.coroutines.ExperimentalCoroutinesApi"
                    )
                    freeCompilerArgs = freeCompilerArgs + "-Xuse-experimental=${experimentalAnnotations.joinToString(",")}"
                    jvmTarget = "1.8"
                }
            }
        }
    }
}