@file:Suppress("unused")

import org.gradle.kotlin.dsl.DependencyHandlerScope
import org.gradle.kotlin.dsl.kotlin

object Version {
    const val Kotlin = "1.3.40"
    const val MySqlConnector = "8.0.16"
    const val Jooq = "3.11.11"
    const val Ktor = "1.2.1"
}

val DependencyHandlerScope.JodaTime get() = "joda-time:joda-time:2.10.2"

val DependencyHandlerScope.Logback get() = "ch.qos.logback:logback-classic:1.3.0-alpha4"

val DependencyHandlerScope.ClassGraph get() = "io.github.classgraph:classgraph:4.8.41"

fun DependencyHandlerScope.ktor(module: String) = "io.ktor:ktor-$module:${Version.Ktor}"

fun DependencyHandlerScope.jooq(module: String) = "org.jooq:$module:${Version.Jooq}"

fun DependencyHandlerScope.coroutines(module: String) = "org.jetbrains.kotlinx:kotlinx-coroutines-$module:1.2.1"

fun DependencyHandlerScope.koin(module: String) = "org.koin:koin-$module:2.0.1"

fun DependencyHandlerScope.implementations() {
    implementation(kotlin("stdlib"))
    implementation(coroutines("core"))
    implementation("org.jetbrains.kotlinx:kotlinx-serialization-runtime:0.11.0")
}

fun DependencyHandlerScope.jupiterTestRunner() {
    testImplementation("org.junit.jupiter:junit-jupiter-engine:5.4.2")
    testImplementation("org.junit.jupiter:junit-jupiter-api:5.5.0-M1")
}

fun DependencyHandlerScope.testImplementations() {
    testImplementation("org.jetbrains.kotlin:kotlin-test:${Version.Kotlin}")
    testImplementation("org.jetbrains.kotlin:kotlin-test-junit5:${Version.Kotlin}")
    testImplementation(coroutines("test"))
}

private fun DependencyHandlerScope.implementation(dependencyNotation: Any) {
    add("implementation", dependencyNotation)
}

private fun DependencyHandlerScope.testImplementation(dependencyNotation: Any) {
    add("testImplementation", dependencyNotation)
}
