import org.jetbrains.kotlin.gradle.tasks.KotlinCompile

plugins {
    id("org.jetbrains.kotlin.jvm")
}

tasks {
    withType<KotlinCompile>().all {
        kotlinOptions {
            val experimentalAnnotations = listOf(
                "kotlinx.coroutines.ExperimentalCoroutinesApi"
            )
            freeCompilerArgs = freeCompilerArgs + "-Xuse-experimental=${experimentalAnnotations.joinToString(",")}"
        }
    }
}

dependencies {
    implementation(kotlin("stdlib"))
    implementation(project(":common"))
    implementation("org.jetbrains.kotlin:kotlin-test:${Version.Kotlin}")
    implementation("org.jetbrains.kotlin:kotlin-test-junit5:${Version.Kotlin}")
    implementation(coroutines("test"))
}
