plugins {
    application
    id("org.flywaydb.flyway") version "6.0.0-beta2"
    id("org.jetbrains.kotlin.jvm")
}

application {
    mainClassName = "io.ktor.server.netty.EngineMain"
}

repositories {
    maven { setUrl("https://jitpack.io") }
}

dependencies {
    implementations()
    implementation(koin("core"))
    implementation(koin("ktor"))
    implementation(project(":common"))
    implementation(JodaTime)
    implementation(Logback)
    implementation(ClassGraph)
    implementation(ktor("server-core"))
    implementation(ktor("server-netty"))
    implementation(ktor("auth-jwt"))
    implementation(jooq("jooq"))
    implementation(jooq("jooq-meta"))
    implementation(jooq("jooq-codegen"))
    implementation("mysql:mysql-connector-java:${Version.MySqlConnector}")
    implementation("org.flywaydb:flyway-core:6.0.0-beta2")
    implementation("com.zaxxer:HikariCP:3.3.1")

    runtime("mysql:mysql-connector-java:${Version.MySqlConnector}")

    jupiterTestRunner()
    testImplementations()
    testImplementation(project(":common:test"))
    testImplementation(ktor("server-test-host"))
}