package com.jwapp;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Query;

import java.util.List;

@Dao
public interface ItemDao {

  @Query("SELECT id, name, price FROM items")
  List<RoomItem> getAll();

  @Query("SELECT id, name, price FROM items WHERE id IN (:ids)")
  List<RoomItem> loadAllByIds(int[] ids);

  @Query("SELECT id, name, price FROM items WHERE name LIKE :name LIMIT 1")
  RoomItem findByName(String name);

  @Insert
  void insertAll(RoomItem... RoomItems);

  @Delete
  void delete(RoomItem RoomItem);

}