package com.jwapp;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;

import android.util.Log;
import android.view.View;
import android.view.Menu;
import android.view.MenuItem;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.room.Room;
import com.google.android.material.floatingactionbutton.FloatingActionButton;

import java.security.SecureRandom;
import java.util.List;
import java.util.Random;

public class MainActivity extends AppCompatActivity {

  private static final String TAG = "JWapp";

  ItemDatabase db;

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    setContentView(R.layout.activity_main);
    Toolbar toolbar = findViewById(R.id.toolbar);
    setSupportActionBar(toolbar);

    db = Room.databaseBuilder(getApplicationContext(),
        ItemDatabase.class, "items-db").build();

    FloatingActionButton fab = findViewById(R.id.fab);
    fab.setOnClickListener(this::actionClick);
  }

  final Random rand = new SecureRandom();

  private void actionClick(View v) {
    new AsyncTask<Void, Void, Void>() {
      @Override
      protected Void doInBackground(Void... voids) {
        ItemDao dao = db.itemDao();
        List<RoomItem> items = dao.getAll();
        if (items == null || items.size() == 0) {
          Log.d(TAG, "Adding items");
          dao.insertAll(
              new RoomItem("123", "Sandwich", rand.nextInt(10) * 100L),
              new RoomItem("456", "Fries", rand.nextInt(10) * 100L));
        } else {
          for (RoomItem item : items) {
            Log.d(TAG, "Item: " + item);
            dao.delete(item);
          }

          Log.d(TAG, "Deleted all items");
        }
        return null;
      }
    }.execute();
  }

  @Override
  public boolean onCreateOptionsMenu(Menu menu) {
    // Inflate the menu; this adds items to the action bar if it is present.
    getMenuInflater().inflate(R.menu.menu_main, menu);

    return true;
  }

  @Override
  public boolean onOptionsItemSelected(MenuItem item) {
    // Handle action bar item clicks here. The action bar will
    // automatically handle clicks on the Home/Up button, so long
    // as you specify a parent activity in AndroidManifest.xml.
    int id = item.getItemId();

    //noinspection SimplifiableIfStatement
    if (id == R.id.action_settings) {
      return true;
    }

    return super.onOptionsItemSelected(item);
  }

  public void onCrashClick(View v) {
    throw new NullPointerException();
  }

  public void onFinishClick(View v) {
    finish();
  }

  @Override
  protected void onDestroy() {
    super.onDestroy();
  }

  private Context getContext() {
    return this;
  }

}
