package com.jwapp;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.PrimaryKey;
import com.library.LibraryItem;

/**
 * I really want to save instances of LibraryItem in my database!
 */
@Entity(tableName = "items", ignoredColumns = "obj")
public class RoomItem extends LibraryItem {

  // I have to put these fields here even though they aren't used to store any
  // data just to make Room happy!
  @PrimaryKey
  @NonNull
  private String id;
  private String name;
  private Long price;

  public RoomItem(String id, String name, Long price) {
    setId(id);
    setName(name);
    setPrice(price);
  }

}
