package com.library;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Imagine this code is actually in a library provided by a third party, source
 * code cannot be modified and the private fields and methods are secrets that
 * could change in future versions of the library.
 */
public class LibraryItem {

  private final JSONObject obj = new JSONObject();

  public Long getPrice() {
    return obj.optLong("price");
  }

  public String getId() {
    return obj.optString("id");
  }

  public String getName() {
    return obj.optString("name");
  }

  public void setPrice(Long price) {
    try {
      obj.put("price", price);
    } catch (JSONException e) {
      // ignored
    }
  }

  public void setId(String id) {
    try {
      obj.put("id", id);
    } catch (JSONException e) {
      // ignored
    }
  }

  public void setName(String name) {
    try {
      obj.put("name", name);
    } catch (JSONException e) {
      // ignored
    }
  }

}
