package com.sslabs.selectiontrackerissue;

import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.selection.ItemDetailsLookup;
import androidx.recyclerview.selection.ItemKeyProvider;
import androidx.recyclerview.selection.SelectionTracker;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;
import java.util.List;

public class ListAdapter extends RecyclerView.Adapter<ListAdapter.ItemViewHolder> {
    private List<String> mData;
    private SelectionTracker mSelectionTracker;

    public ListAdapter() {
        mData = new ArrayList<>();
    }

    @NonNull
    @Override
    public ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_item_layout, parent, false);
        return new ItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull ItemViewHolder holder, int position) {
        boolean selected = mSelectionTracker != null && mSelectionTracker.isSelected(getItemId(position));
        holder.bind(mData.get(position), selected);
    }

    @Override
    public int getItemCount() {
        return mData.size();
    }

    @Override
    public long getItemId(int position) {
        return mData.get(position).hashCode();
    }

    public int getItemPosition(@NonNull Long key) {
        List<String> data = getData();
        for (int index = 0; index < data.size(); index++) {
            String item = data.get(index);
            if ((long) item.hashCode() == key) {
                return index;
            }
        }
        return RecyclerView.NO_POSITION;
    }

    public void add(String newData) {
        mData.add(newData);
    }

    public void removeFirst() {
        mData.remove(0);
        notifyItemRemoved(0);
    }

    public List<String> getData() {
        return mData;
    }

    public String getDatum(int position) {
        return mData.get(position);
    }

    public void setSelectionTracker(SelectionTracker tracker) {
        mSelectionTracker = tracker;
    }

    static class ItemViewHolder extends RecyclerView.ViewHolder {
        private String mDatum;
        private View mContainerView;
        private TextView mTextView;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);
            mContainerView = itemView;
            mTextView =itemView.findViewById(R.id.list_item_text_view);
        }

        void bind(String itemData, boolean activated) {
            mDatum = itemData;
            mTextView.setText(itemData);
            mContainerView.setActivated(activated);
        }

        public ItemDetailsLookup.ItemDetails<Long> getItemDetails() {
            return new ItemDetailsLookup.ItemDetails<Long>() {
                @Override
                public int getPosition() {
                    return getAdapterPosition();
                }

                @Override
                public Long getSelectionKey() {
                    return (long) mDatum.hashCode();
                }

                @Override
                public boolean inSelectionHotspot(@Nullable MotionEvent e) {
                    return true;
                }
            };
        }
    }

    static class PositionKeyProvider extends ItemKeyProvider<Long> {
        private ListAdapter mAdapter;

        PositionKeyProvider(ListAdapter adapter) {
            super(ItemKeyProvider.SCOPE_MAPPED);
            mAdapter = adapter;
        }

        @Nullable
        @Override
        public Long getKey(int position) {
            return mAdapter.getItemId(position);
        }

        @Override
        public int getPosition(@NonNull Long key) {
            return mAdapter.getItemPosition(key);
        }
    }
}
