package com.sslabs.selectiontrackerissue;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.selection.ItemDetailsLookup;
import androidx.recyclerview.selection.SelectionTracker;
import androidx.recyclerview.selection.StorageStrategy;
import androidx.recyclerview.widget.RecyclerView;

import android.os.Bundle;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;

public class MainActivity extends AppCompatActivity implements View.OnClickListener {
    private static final String TAG = MainActivity.class.getName();

    private ListAdapter mAdapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        setupViews();
        initList();
    }

    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.remove_first_item_fab) {
            mAdapter.removeFirst();
        }
    }

    private void setupViews() {
        mAdapter = new ListAdapter();
        mAdapter.setHasStableIds(true);

        RecyclerView recyclerView = findViewById(R.id.recycler_view);
        recyclerView.setAdapter(mAdapter);
        SelectionTracker<Long> selectionTracker = new SelectionTracker.Builder(
                "selection-tracker",
                recyclerView,
                new ListAdapter.PositionKeyProvider(mAdapter),
                new DetailsLookup(recyclerView),
                StorageStrategy.createLongStorage())
                .withSelectionPredicate(new SimpleSelectionPredicate())
                .build();
        selectionTracker.addObserver(new SelectionTracker.SelectionObserver<Long>() {
            @Override
            public void onItemStateChanged(@NonNull Long key, boolean selected) {
                logMessage("onItemStateChanged() -> key=" + key.toString() + "; selected=" + (selected ? "selected" : "unselected"));
            }

            @Override
            public void onSelectionRefresh() {
                logMessage("onSelectionRefresh()");
            }

            @Override
            public void onSelectionChanged() {
                logMessage("onSelectionChanged()");
            }

            @Override
            public void onSelectionRestored() {
                logMessage("onSelectionRestored()");
            }

            private void logMessage(String message) {
                Log.d(TAG, message);
            }
        });
        mAdapter.setSelectionTracker(selectionTracker);
        findViewById(R.id.remove_first_item_fab).setOnClickListener(this);
    }

    private void initList() {
        mAdapter.add("First");
        mAdapter.add("Second");
        mAdapter.add("Third");
        mAdapter.add("Fourth");
    }

    static class DetailsLookup extends ItemDetailsLookup<Long> {
        private RecyclerView mRecyclerView;

        DetailsLookup(RecyclerView recyclerView) {
            mRecyclerView = recyclerView;
        }

        @Nullable
        @Override
        public ItemDetails<Long> getItemDetails(@NonNull MotionEvent e) {
            View view = mRecyclerView.findChildViewUnder(e.getX(), e.getY());
            if (view != null) {
                RecyclerView.ViewHolder viewHolder = mRecyclerView.getChildViewHolder(view);
                if (viewHolder instanceof ListAdapter.ItemViewHolder) {
                    ListAdapter.ItemViewHolder agreementViewHolder =
                            (ListAdapter.ItemViewHolder) viewHolder;
                    return agreementViewHolder.getItemDetails();
                }
            }
            return null;
        }
    }

    static class SimpleSelectionPredicate extends SelectionTracker.SelectionPredicate {

        @Override
        public boolean canSetStateForKey(@NonNull Object key, boolean nextState) {
            return true;
        }

        @Override
        public boolean canSetStateAtPosition(int position, boolean nextState) {
            return true;
        }

        @Override
        public boolean canSelectMultiple() {
            return false;
        }
    }
}
