package com.test.myapplication.db;



import android.arch.persistence.room.Database;
import android.arch.persistence.room.Room;
import android.arch.persistence.room.RoomDatabase;
import android.content.Context;

import com.test.myapplication.db.entities.trips.list.RefListDAO;
import com.test.myapplication.db.entities.trips.list.RefListEntity;


/**
 * Created by Caraka on 7/20/17.
 */
@Database(entities = {
        RefListEntity.class
}, version = 1, exportSchema = false)
public abstract class RefBookingDB extends RoomDatabase {
    private static final String DB_NAME = "I_RDB";

    private static RefBookingDB sInstance;


    public abstract RefListDAO getRefListDao();



    public static RefBookingDB getRefDB(Context context) {
        if(sInstance == null) {
            sInstance =
                    Room.databaseBuilder(context, RefBookingDB.class, DB_NAME)
                            .allowMainThreadQueries()
                            .build();
            onCreateDb(sInstance);
        }
        return sInstance;
    }

    private static void onCreateDb(RefBookingDB database) {

    }

}
