package com.test.myapplication.db.entities.trips.list;


import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.Index;
import androidx.room.PrimaryKey;

@Entity(
        tableName = RefListEntity.TABLE_NAME,
        indices = {
                @Index(
                        value = {
                                RefConstant.IS_ACTIVE_BOOKING,
                                RefConstant.REF_TYPE
                        }
                ),
                @Index(
                        value = {
                                RefConstant.BOOKING_ID,
                                RefConstant.REF_ID,
                                RefConstant.PRODUCT_MAPPING_ID,
                                RefConstant.REF_TYPE
                        },
                        unique = true
                )
        }
)

public class RefListEntity {
    public static final String TABLE_NAME = "ref_list";

    @PrimaryKey(autoGenerate = true)
    @ColumnInfo(name = RefConstant.ID)
    private int id;

    @ColumnInfo(name = RefConstant.BOOKING_ID)
    private String bookingId;

    @ColumnInfo(name = RefConstant.REF_ID)
    private String refId = "";

    @ColumnInfo(name = RefConstant.PRODUCT_MAPPING_ID)
    private String productMappingId = "";

    @ColumnInfo(name = RefConstant.REF_TYPE)
    private String refType;

    @ColumnInfo(name = RefConstant.IS_ACTIVE_BOOKING)
    private boolean isActiveBooking;

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getBookingId() {
        return bookingId;
    }

    public void setBookingId(String bookingId) {
        this.bookingId = bookingId;
    }

    public String getRefId() {
        return refId;
    }

    public void setRefId(String refId) {
        if(refId == null) refId = "";
        this.refId = refId;
    }

    public String getProductMappingId() {
        return productMappingId;
    }

    public void setProductMappingId(String productMappingId) {
        if(productMappingId == null) productMappingId = "";
        this.productMappingId = productMappingId;
    }

    public String getRefType() {
        return refType;
    }

    public void setRefType(String refType) {
        this.refType = refType;
    }

    public boolean isActiveBooking() {
        return isActiveBooking;
    }

    public void setActiveBooking(boolean activeBooking) {
        isActiveBooking = activeBooking;
    }

}
