package com.example.test.aidl;

import androidx.appcompat.app.AppCompatActivity;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;

public class MainActivity extends AppCompatActivity {

    private ServiceConnection connection3 = new ServiceConnection() {
        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            try {
                IMyAidlInterface3 service = IMyAidlInterface3.Stub.asInterface(iBinder);
                service.method();
            } catch (RemoteException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        bindService(
                new Intent(this, MyService3.class),
                connection3,
                Context.BIND_AUTO_CREATE
        );
        bindService(
                new Intent(this, MyService3.class),
                connection3,
                Context.BIND_AUTO_CREATE
        );
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();

        unbindService(connection3);
    }
}
