package org.home.assignment.workerbug

import android.content.Context
import androidx.appcompat.app.AppCompatActivity

import android.os.Bundle
import android.util.Log
import androidx.lifecycle.LiveData
import androidx.lifecycle.Observer
import androidx.work.ExistingWorkPolicy
import androidx.work.OneTimeWorkRequest
import androidx.work.WorkInfo
import androidx.work.WorkManager
import org.home.assignment.workerbug.worker.SyncWorker

class MainActivity : AppCompatActivity(), Observer<WorkInfo> {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)


        constructWorkRequest(applicationContext).observe(this, this)

    }

    private fun constructWorkRequest(application: Context): LiveData<WorkInfo> {
        val refreshDatabaseWork: OneTimeWorkRequest = OneTimeWorkRequest.Builder(SyncWorker::class.java)
                .addTag(WORK_IN_PROGRESS_TAG).build()
        WorkManager.getInstance(application).beginUniqueWork(UNIQUE_WORK_NAME, ExistingWorkPolicy.KEEP, refreshDatabaseWork).enqueue()
        return WorkManager.getInstance(application).getWorkInfoByIdLiveData(refreshDatabaseWork.id)
    }

    override fun onChanged(workInfo: WorkInfo) {
        Log.d(TAG, "$workInfo")
    }


    companion object {
        private const val TAG = "MainActivity"
        private const val WORK_IN_PROGRESS_TAG = "SYNC-IN-PROGRESS-TAG"
        private const val UNIQUE_WORK_NAME = "SYNC-UNIQUE_WORK_NAME"
    }
}
