package org.home.assignment.workerbug

import android.app.Application
import android.util.Log
import androidx.work.Configuration
import androidx.work.WorkManager
import java.util.concurrent.Executors

class ScopusDiscoveryApplication : Application() {

    override fun onCreate() {
        super.onCreate()
        initWorkManager()

    }

    private fun initWorkManager() {
        val configuration = Configuration.Builder()
                .setMinimumLoggingLevel(Log.VERBOSE)
                .setExecutor(Executors.newCachedThreadPool())
                .build()
        WorkManager.initialize(this, configuration)
    }

    companion object {

        private val TAG = "ScopusDiscoveryApplicat"
    }
}
