package com.vidyacharan.samplebiometricapp

import android.os.Bundle
import android.util.Log
import androidx.appcompat.app.AppCompatActivity
import androidx.biometric.BiometricPrompt
import kotlinx.android.synthetic.main.activity_main.*
import java.util.concurrent.ExecutorService
import java.util.concurrent.Executors

class MainActivity : AppCompatActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)

        launchBiometric.setOnClickListener {
            showBiometricPrompt(this)
        }

    }

    companion object {

        const val TAG = "MainActivity"

        private val executor: ExecutorService by lazy { Executors.newSingleThreadExecutor() }

        fun showBiometricPrompt(
            activity: AppCompatActivity
            ): BiometricPrompt {

            val biometricPrompt =
                BiometricPrompt(activity, executor, object : BiometricPrompt.AuthenticationCallback() {

                    override fun onAuthenticationError(errorCode: Int, errorString: CharSequence) {
                        super.onAuthenticationError(errorCode, errorString)

                        Log.d(TAG, "Error using BioMetrics: $errorCode: $errorString")
                    }

                    override fun onAuthenticationSucceeded(result: BiometricPrompt.AuthenticationResult) {
                        super.onAuthenticationSucceeded(result)

                        Log.d(TAG, "onAuthentication Success")
                    }

                    override fun onAuthenticationFailed() {
                        super.onAuthenticationFailed()
                        Log.d(TAG, "onAuthentication Fail")
                    }
                })
            val promptInfo = BiometricPrompt.PromptInfo.Builder()
                .setTitle("Biometric Sign In")
                .setNegativeButtonText("Cancel")
                .build()

            biometricPrompt.authenticate(promptInfo)

            return biometricPrompt
        }

    }
}
