/*
 * Copyright 2019, The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.example.android.navigationsample

import androidx.fragment.app.testing.launchFragmentInContainer
import androidx.navigation.NavController
import androidx.navigation.NavDestination
import androidx.navigation.NavGraph
import androidx.navigation.Navigation
import androidx.test.espresso.Espresso.onView
import androidx.test.espresso.action.ViewActions.click
import androidx.test.espresso.matcher.ViewMatchers.withId
import androidx.test.ext.junit.runners.AndroidJUnit4
import org.junit.Test
import org.junit.runner.RunWith
import org.mockito.Mockito.`when`
import org.mockito.Mockito.mock
import org.mockito.Mockito.verify

/**
 * A simple test class that can be run both on device (or emulator) or on the host (as a JVM test
 * using Robolectric).
 */
@RunWith(AndroidJUnit4::class)
class TitleScreenTestKotlin {

    @Test
    fun test1() {
        // Create a mock NavController
        val mockNavGraph = mock(NavGraph::class.java)
        `when`(mockNavGraph.getStartDestination()).thenReturn(1)
        `when`(mockNavGraph.findNode(1)).thenReturn(mock(NavDestination::class.java))
        val mockNavController = mock(NavController::class.java)
        `when`(mockNavController.graph).thenReturn(mockNavGraph)

        // Create a graphical FragmentScenario for the TitleScreen
        launchFragmentInContainer() {
            TitleScreen().also { fragment ->
                fragment.viewLifecycleOwnerLiveData.observeForever {
                    if (it != null) {
                        Navigation.setViewNavController(fragment.requireView(), mockNavController)
                    }
                }
            }
        }

        // Verify that performing a click prompts the correct Navigation action
        onView(withId(R.id.play_btn)).perform(click())
        verify(mockNavController).navigate(R.id.action_title_screen_to_register)
    }
}
