package com.xapo.rgtask.view.fragments

import android.os.Bundle
import androidx.navigation.NavArgs
import kotlin.String
import kotlin.jvm.JvmStatic

data class BFragmentArgs(
  val token: String? = null
) : NavArgs {
  fun toBundle(): Bundle {
    val result = Bundle()
    result.putString("token", this.token)
    return result
  }

  companion object {
    @JvmStatic
    fun fromBundle(bundle: Bundle): BFragmentArgs {
      bundle.setClassLoader(BFragmentArgs::class.java.classLoader)
      val __token : String?
      if (bundle.containsKey("token")) {
        __token = bundle.getString("token")
      } else {
        __token = null
      }
      return BFragmentArgs(__token)
    }
  }
}
