package com.xapo.rgtask.view.fragments

import android.os.Bundle
import androidx.navigation.NavDirections
import com.xapo.githubtask.MainNavigationDirections
import com.xapo.githubtask.R
import kotlin.Int
import kotlin.String

class LoginFragmentDirections private constructor() {
  private data class OpenFragmentB(
    val token: String? = null
  ) : NavDirections {
    override fun getActionId(): Int = R.id.open_fragment_b

    override fun getArguments(): Bundle {
      val result = Bundle()
      result.putString("token", this.token)
      return result
    }
  }

  companion object {
    fun openFragmentB(token: String? = null): NavDirections = OpenFragmentB(token)

    fun globalActionOpenLogin(): NavDirections = MainNavigationDirections.globalActionOpenLogin()
  }
}
