package com.xapo.rgtask.view.customview

import android.content.Context
import android.util.AttributeSet
import android.view.View
import androidx.appcompat.widget.Toolbar
import com.xapo.githubtask.R
import kotlinx.android.synthetic.main.toolbar_main.view.*

internal class ToolbarCustomView : Toolbar {

    constructor(context: Context?) : super(context)
    constructor(context: Context?, attrs: AttributeSet?) : super(context, attrs)
    constructor(context: Context?, attrs: AttributeSet?, defStyleAttr: Int) : super(
            context,
            attrs,
            defStyleAttr
    )

    init {
        inflate(context, R.layout.toolbar_main, this)
        setBackgroundResource(R.drawable.toolbar_background)
    }

    fun setToolbarTitle(toolbarTitle: String) {
        ic_toolbar.visibility = GONE
        title = toolbarTitle
    }

    fun showToolbarIcon() {
        ic_toolbar.visibility = View.VISIBLE
        title = null
    }
}