package com.xapo.rgtask.view.fragments

import android.os.Bundle
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import androidx.navigation.fragment.findNavController
import androidx.navigation.fragment.navArgs
import com.xapo.githubtask.R
import kotlinx.android.synthetic.main.fragment_a_layout.*

class BFragment : Fragment() {

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View =
            inflater.inflate(R.layout.fragment_b_layout, container, false)

    override fun onStart() {
        super.onStart()
        button.setOnClickListener {
            findNavController().navigate(BFragmentDirections.openFragmentA())
        }
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        arguments?.run {
            val args by navArgs<BFragmentArgs>()
            //Should be null instead "@null"?
            Log.d("ARGS", "Token ${args.token}")
        }
    }
}