package com.example.bugs;

import android.os.Build;
import android.os.Bundle;
import android.view.View;

import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.snackbar.Snackbar;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.core.view.ViewCompat;

public class MainActivity extends AppCompatActivity {

  @Override
  protected void onCreate (Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);

    if (Build.VERSION_CODES.LOLLIPOP <= Build.VERSION.SDK_INT)
      getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN | View.SYSTEM_UI_FLAG_LAYOUT_STABLE | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION);

    setContentView(R.layout.activity_main);
    Toolbar toolbar = findViewById(R.id.toolbar);
    setSupportActionBar(toolbar);

    // BUG: https://issuetracker.google.com/issues/142669889
    FloatingActionButton fab = findViewById(R.id.fab);
    fab.setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick (View view) {

        final Snackbar snackbar = Snackbar.make(view, "Replace with your own action", Snackbar.LENGTH_LONG)
            .setAction("Action", null);
        final View snackBarView = snackbar.getView();

        // BUG: BaseTransientBottomBar always fitsSystemWindow=true which makes CoordinatorLayout measure without insets.
        snackBarView.setFitsSystemWindows(false);

        // BUG: BaseTransientBottomBar's default OnApplyWindowInsetsListener only handle bottom inset, by adding a margin, remove it.
        ViewCompat.setOnApplyWindowInsetsListener(snackBarView, null);
        snackbar.show();
      }
    });
  }

}
