package gmk57.testbiometricx

import android.os.Bundle
import android.util.Log
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import androidx.biometric.BiometricPrompt
import androidx.core.content.ContextCompat
import kotlinx.android.synthetic.main.activity_main.*

class MainActivity : AppCompatActivity(R.layout.activity_main) {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        val mainExecutor = ContextCompat.getMainExecutor(this)

        val callback = object : BiometricPrompt.AuthenticationCallback() {
            override fun onAuthenticationError(errorCode: Int, errString: CharSequence) {
                log("onAuthenticationError, errorCode: $errorCode, errString: $errString")
            }
            override fun onAuthenticationFailed() {
                log("onAuthenticationFailed")
            }
            override fun onAuthenticationSucceeded(result: BiometricPrompt.AuthenticationResult) {
                log("onAuthenticationSucceeded")
            }
        }

        val prompt = BiometricPrompt(this, mainExecutor, callback)

        val promptInfo = BiometricPrompt.PromptInfo.Builder()
            .setTitle("Test Biometric X")
            .setDeviceCredentialAllowed(true)
            .build()

        button.setOnClickListener { prompt.authenticate(promptInfo) }
    }

    fun log(message: String) {
        Log.v("MainActivity", message)
        Toast.makeText(this, message, Toast.LENGTH_LONG).show()
    }
}
