package gmk57.testbiometricq

import android.hardware.biometrics.BiometricPrompt
import android.os.Bundle
import android.os.CancellationSignal
import android.util.Log
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import kotlinx.android.synthetic.main.activity_main.*

class MainActivity : AppCompatActivity(R.layout.activity_main) {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        val prompt = BiometricPrompt.Builder(this)
            .setTitle("Test Biometric Q")
            .setDeviceCredentialAllowed(true)
            .build()

        val callback = object : BiometricPrompt.AuthenticationCallback() {
            override fun onAuthenticationError(errorCode: Int, errString: CharSequence?) {
                log("onAuthenticationError, errorCode: $errorCode, errString: $errString")
            }
            override fun onAuthenticationFailed() {
                log("onAuthenticationFailed")
            }
            override fun onAuthenticationHelp(helpCode: Int, helpString: CharSequence?) {
                log("onAuthenticationHelp, helpCode: $helpCode, helpString: $helpString")
            }
            override fun onAuthenticationSucceeded(result: BiometricPrompt.AuthenticationResult?) {
                log("onAuthenticationSucceeded")
            }
        }

        button.setOnClickListener {
            prompt.authenticate(CancellationSignal(), mainExecutor, callback)
        }
    }

    fun log(message: String) {
        Log.v("MainActivity", message)
        Toast.makeText(this, message, Toast.LENGTH_LONG).show()
    }
}
