package io.hetero.myapplication;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.biometric.BiometricPrompt;

import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.widget.Toast;

import java.util.concurrent.Executor;

public class MainActivity extends AppCompatActivity {

	private Handler handler = new Handler();

	private Executor executor = new Executor() {
		@Override
		public void execute(Runnable command) {
			handler.post(command);
		}
	};

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
	}

	public void onClickShowBiometricPrompt(View view) {
		showBiometricPrompt();
	}

	private void showBiometricPrompt() {
		BiometricPrompt.PromptInfo promptInfo =
				new BiometricPrompt.PromptInfo.Builder()
						.setTitle("Biometric login for my app")
						.setSubtitle("Log in using your biometric credential")
						// .setNegativeButtonText("Cancel")
						.setDeviceCredentialAllowed(true)
						.build();

		BiometricPrompt biometricPrompt = new BiometricPrompt(MainActivity.this,
				executor, new BiometricPrompt.AuthenticationCallback() {
			@Override
			public void onAuthenticationError(int errorCode,
			                                  @NonNull CharSequence errString) {
				super.onAuthenticationError(errorCode, errString);
				Toast.makeText(getApplicationContext(),
						"Authentication error: " + errString, Toast.LENGTH_SHORT)
						.show();
			}

			@Override
			public void onAuthenticationSucceeded(
					@NonNull BiometricPrompt.AuthenticationResult result) {
				super.onAuthenticationSucceeded(result);
				BiometricPrompt.CryptoObject authenticatedCryptoObject =
						result.getCryptoObject();
				// User has verified the signature, cipher, or message
				// authentication code (MAC) associated with the crypto object,
				// so you can use it in your app's crypto-driven workflows.
			}

			@Override
			public void onAuthenticationFailed() {
				super.onAuthenticationFailed();
				Toast.makeText(getApplicationContext(), "Authentication failed",
						Toast.LENGTH_SHORT)
						.show();
			}
		});

		// Displays the "log in" prompt.
		biometricPrompt.authenticate(promptInfo);
	}
}
