package com.example.sample;

import androidx.databinding.BaseObservable;
import androidx.databinding.ObservableArrayMap;
import androidx.databinding.ObservableBoolean;
import androidx.databinding.ObservableField;
import androidx.recyclerview.widget.RecyclerView;

import java.util.Collections;
import java.util.List;

/**
 * Created by Alessandro Frigerio on 11/04/2018.
 */
public class FisherDataDescriptor extends BaseObservable {

    public ObservableBoolean hasDynamicData = new ObservableBoolean();
    public ObservableArrayMap<String, FisherHead> staticFisherHeads = new ObservableArrayMap<>();
//    public ObservableField<FisherAdapter> fisherAdapter = new ObservableField<>(new FisherAdapter(Collections.emptyList()));

    public static String getStatisticKey(RepresentationType representationType, StatisticType statisticType) {
        return "?";//representationType.getValue() + "_" + statisticType.getValue();
    }

    public void loadData(FisherDataView view, RepresentationType representationType, StatisticType statisticType) {
//        getSpecificFisherHead(representationType, statisticType)
//                .observeOn(AndroidSchedulers.mainThread())
//                .subscribeOn(Schedulers.io())
//                .subscribe(result -> view.setFisherHead(result));
    }

    public void loadData(final RecyclerView view) {
//        DaemonData.data.statisticModel.rxGetDynamics()
//                .observeOn(AndroidSchedulers.mainThread())
//                .subscribeOn(Schedulers.io())
//                .subscribe(result -> {
//                    FisherAdapter adapter = new FisherAdapter(result);
//                    view.setAdapter(adapter);
//
//                    hasDynamicData.set(result.size() > 0);
//                });
    }

    public void putStaticFisherHead(RepresentationType representationType, StatisticType statisticType, FisherHead head) {
        String key = getStatisticKey(representationType, statisticType);
        staticFisherHeads.put(key, head);
    }

    public void setDynamicData(List<FisherHead> fisherHeads) {
        //fisherAdapter.set(new FisherAdapter(fisherHeads));
        hasDynamicData.set(fisherHeads.size() > 0);
    }
}
