package com.ersen.viewpager2fragmenubug

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import androidx.viewpager2.widget.ViewPager2

class MainActivity : AppCompatActivity() {

    companion object {
        private const val FRAGMENT_A_ID = 1L
        private const val FRAGMENT_B_ID = 2L
        private const val FRAGMENT_C_ID = 3L
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        findViewById<ViewPager2>(R.id.view_pager).apply {
            offscreenPageLimit = 3
            val adapter = ViewPager2FragmentAdapter(this@MainActivity)
            setAdapter(adapter)
            adapter.setItems(
                listOf(
                    ViewPager2FragmentAdapter.Item(FRAGMENT_A_ID) {
                        FragmentA()
                    },

                    ViewPager2FragmentAdapter.Item(FRAGMENT_B_ID) {
                        FragmentB()
                    },

                    ViewPager2FragmentAdapter.Item(FRAGMENT_C_ID) {
                        FragmentC()
                    }
                )
            )
        }
    }
}
