//
//  ViewController.swift
//  gps_dash_ios
//
//  Created by doi on 2019/12/06.
//  Copyright © 2019 AGENDA. All rights reserved.
//

import UIKit
import GoogleMaps

class ViewController: UIViewController {
    var mapView: GMSMapView?
    var camera: GMSCameraPosition?
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.camera = GMSCameraPosition.init(latitude: 43.068661,
                                            longitude: 141.350755,
                                                 zoom: 16.0);
        
        self.mapView = GMSMapView.init(frame: CGRect.zero, camera: self.camera!)
         
        self.mapView!.isMyLocationEnabled = true;
         
        self.mapView?.settings.myLocationButton = true;
        
        self.mapView!.delegate = self;
         
        self.view = self.mapView;
        self.drawPoint()
    }


    private func drawSapporoToOdori() {
        let path = GMSMutablePath()
        
        let sapproPosition = CLLocationCoordinate2D(latitude: GPSSampleConst.SAPPORO_STATION_LATITUDE, longitude: GPSSampleConst.SAPPORO_STATION_LONGITUDE)
        path.add(sapproPosition)
        let odoriPosition = CLLocationCoordinate2DMake(GPSSampleConst.ODORI_STATION_LATITUDE, GPSSampleConst.ODORI_STATION_LONGITUDE)
        path.add(odoriPosition)
        
        let poly = GMSPolyline(path: path)
        let styles = [GMSStrokeStyle.solidColor(.systemBlue),
                      GMSStrokeStyle.solidColor(.clear)]
        
        let value = self.mapView!.projection.points(forMeters: 1, at: self.camera!.target);
        let scale = 1.0 / value;
        let dashLength = NSNumber(value: Float(4.0 * scale))
        let gapLength = NSNumber(value: Float(10.0 * scale))
        poly.spans = GMSStyleSpans(poly.path!, styles, [dashLength, gapLength], .geodesic)
        poly.strokeWidth = 4.0
        poly.map = self.mapView
        poly.isTappable = false
    }
    
    private func drawSapporoToShinchitose() {
        let path = GMSMutablePath()
        let sapporoPosition = CLLocationCoordinate2D(latitude: GPSSampleConst.SAPPORO_STATION_LATITUDE, longitude: GPSSampleConst.SAPPORO_STATION_LONGITUDE)
        path.add(sapporoPosition)
        let shinchitosePosition = CLLocationCoordinate2D(latitude: GPSSampleConst.SHIN_CHITOSE_LATITUDE,longitude: GPSSampleConst.SHIN_CHITOSE_LONGITUDE)
        path.add(shinchitosePosition)

        let poly = GMSPolyline(path: path)
        let styles = [GMSStrokeStyle.solidColor(.systemBlue),
                      GMSStrokeStyle.solidColor(.clear)]

        let value = self.mapView!.projection.points(forMeters: 1, at: self.camera!.target);
        let scale = 1.0 / value;
        let dashLength = NSNumber(value: Float(4.0 * scale))
        let gapLength = NSNumber(value: Float(10.0 * scale))
        poly.spans = GMSStyleSpans(poly.path!, styles, [dashLength, gapLength], .geodesic)
        poly.strokeWidth = 4.0
        poly.map = self.mapView
        poly.isTappable = false
        
    }
    func drawPoint() {
        self.drawSapporoToOdori()
        self.drawSapporoToShinchitose()
    }
    
}

extension ViewController: GMSMapViewDelegate {
    func mapView(_ mapView: GMSMapView, idleAt position: GMSCameraPosition) {
        self.mapView?.clear()
        self.drawPoint()
    }
}
