package com.commonsware.roomkotlinbugs

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query

@Dao
abstract class Bookstore {
  @Insert
  abstract suspend fun save(category: Category)

  @Insert
  abstract suspend fun save(vararg books: Book)

  suspend fun loadCategoryByTransaction(shortCode: String) =
    _loadCategory(shortCode) to _loadBooksInCategory(shortCode)

  @Query("SELECT * FROM categories WHERE shortCode = :shortCode")
  abstract suspend fun _loadCategory(shortCode: String): Category

  @Query("SELECT * FROM books WHERE categoryShortCode = :shortCode")
  abstract suspend fun _loadBooksInCategory(shortCode: String): List<Book>
}