package com.commonsware.roomkotlinbugs

import androidx.arch.core.executor.testing.InstantTaskExecutorRule
import androidx.room.Room
import androidx.test.ext.junit.runners.AndroidJUnit4
import androidx.test.platform.app.InstrumentationRegistry
import kotlinx.coroutines.launch
import kotlinx.coroutines.test.runBlockingTest
import org.junit.Rule
import org.junit.Test
import org.junit.runner.RunWith

@RunWith(AndroidJUnit4::class)
class OneToManyAbstractClassTransactionTest {
  @get:Rule
  val instantExecutorRule = InstantTaskExecutorRule()

  private val db = Room.inMemoryDatabaseBuilder(
    InstrumentationRegistry.getInstrumentation().targetContext,
    MiscDatabase::class.java
  )
    .build()
  private val underTest = db.bookstoreOneToMany()

  @Test
  fun loadByTransaction() = runBlockingTest {
    val category =
      Category(shortCode = "stuff", displayName = "Books About Stuff")
    val bookOne = Book(
      isbn = "035650056X",
      title = "Feed",
      categoryShortCode = category.shortCode
    )
    val bookTwo = Book(
      isbn = "0451459792",
      title = "Dies the Fire",
      categoryShortCode = category.shortCode
    )

    launch {
      underTest.save(category)
      underTest.save(bookOne, bookTwo)

      val (loadedCategory, loadedBooks) =
        underTest.loadCategoryByTransaction(category.shortCode)

/*
      assertThat(category, equalTo(loadedCategory))
      assertThat(loadedBooks.toSet(), equalTo(setOf(bookOne, bookTwo)))
*/
    }.join()
  }
}
