package com.commonsware.roomkotlinbugs

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.ForeignKey
import androidx.room.ForeignKey.CASCADE
import androidx.room.PrimaryKey

@Entity(
  tableName = "books",
  foreignKeys = [ForeignKey(
    entity = Category::class,
    parentColumns = arrayOf("shortCode"),
    childColumns = arrayOf("categoryShortCode"),
    onDelete = CASCADE
  )]
)
data class Book(
  @PrimaryKey
  val isbn: String,
  val title: String,
  @ColumnInfo(index = true) var categoryShortCode: String
)