package com.commonsware.roomkotlinbugs

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import androidx.room.Transaction

@Dao
interface Bookstore {
  @Insert
  suspend fun save(category: Category)

  @Insert
  suspend fun save(vararg books: Book)

  @Transaction
  suspend fun loadCategoryByTransaction(shortCode: String) =
    _loadCategory(shortCode) to _loadBooksInCategory(shortCode)

  @Query("SELECT * FROM categories WHERE shortCode = :shortCode")
  suspend fun _loadCategory(shortCode: String): Category

  @Query("SELECT * FROM books WHERE categoryShortCode = :shortCode")
  suspend fun _loadBooksInCategory(shortCode: String): List<Book>
}