package com.marcardar.viewbindingapplication

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.widget.TextView
import com.marcardar.viewbindingapplication.databinding.ActivityMainBinding

class MainActivity : AppCompatActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        val binding = ActivityMainBinding.inflate(layoutInflater)
        // next two lines show IDE compilation error: cannot access class warning/error (app still runs fine)
        val textView = binding.myText as TextView  // included layout is simple textview
        val complexText = binding.myComplexText.complexTextView // included layout is framelayout containing textview
        textView.text = "found textView"
        complexText.text = "found complex textView"
        setContentView(binding.root)
    }
}
