package com.android.doubletransitionbug

import android.os.Bundle
import android.transition.Fade
import android.transition.Slide
import android.view.Gravity
import android.view.View
import android.widget.Button

import androidx.appcompat.app.AppCompatActivity
import androidx.fragment.app.Fragment

class MainActivity : AppCompatActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)

        supportFragmentManager.beginTransaction()
                .add(R.id.content, Fragment(R.layout.fragment_second))
                .commit()

        findViewById<Button>(R.id.important_button).setOnClickListener { switchFragment() }
    }

    private fun switchFragment() {
        val currentFragment = supportFragmentManager.findFragmentById(R.id.content)

        currentFragment!!.exitTransition = Fade()

        val second = Fragment(R.layout.fragment_second)
        second.enterTransition = Slide(Gravity.BOTTOM)

        val first = Fragment(R.layout.fragment_first)
        first.enterTransition = Fade().setDuration(5000)

        supportFragmentManager.beginTransaction()
                .setReorderingAllowed(true)
                .add(R.id.content, first)
                .add(R.id.content, second)
                .hide(currentFragment)
                .addToBackStack(null)
                .commit()

    }

}

