package com.evilduck.fragmetntransitionbugdemo;

import android.os.Bundle;
import android.transition.Fade;
import android.transition.Slide;
import android.view.Gravity;
import android.view.View;

import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;

public class MainActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        getSupportFragmentManager().beginTransaction()
                .add(R.id.content, new FirstFragment())
                .commit();

        findViewById(R.id.important_button).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                switchFragment();
            }
        });
    }

    private void switchFragment() {
        Fragment currentFragment = getSupportFragmentManager().findFragmentById(R.id.content);

        currentFragment.setExitTransition(new Fade());

        final Fragment second = new Fragment(R.layout.fragment_second);
        second.setEnterTransition(new Slide(Gravity.BOTTOM));

        final Fragment first = new Fragment(R.layout.fragment_first);
        first.setEnterTransition(new Fade().setDuration(5000));

        getSupportFragmentManager().beginTransaction()
                .setReorderingAllowed(true)
                .add(R.id.content, first)
                .add(R.id.content, second)
                .hide(currentFragment)
                .addToBackStack(null)
                .commit();

    }

}
