package com.example.myapplication

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.os.Handler
import androidx.databinding.DataBindingUtil
import com.example.myapplication.databinding.ActivityMainBinding
import com.example.myapplication.databinding.ActivityMainRelativeBinding

class MainActivity : AppCompatActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        // this will incorrectly hide the NestedScrollView
        val binding = DataBindingUtil.setContentView<ActivityMainBinding>(this, R.layout.activity_main)
        // this will correctly show the NestedScrollView
//        val binding = DataBindingUtil.setContentView<ActivityMainRelativeBinding>(this, R.layout.activity_main_relative)
        binding.loading = true
        Handler().postDelayed({
            binding.loading = false
        }, 50)
    }
}
