package se.ansman.fragmenttargetbug

import android.os.Bundle
import android.view.View
import androidx.fragment.app.Fragment
import androidx.fragment.app.commit
import com.google.android.material.transition.Hold


class FirstFragment : Fragment(R.layout.fragment_first) {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        exitTransition = Hold()
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        view.findViewById<View>(R.id.action_secondFragment).setOnClickListener {
            parentFragmentManager.commit {
                addSharedElement(it, it.transitionName)
                setReorderingAllowed(true)
                addToBackStack(null)
                replace(id, SecondFragment().also {
                    // Comment this out to fix the transition
                    it.setTargetFragment(this@FirstFragment, 4711)
                })
            }
        }
    }
}
